/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.ICETracer;
import com.ice.util.StringUtilities;
import com.ice.util.UserProperties;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuProperties {
    public static JPopupMenu loadPopupMenu(String menuPropertyName, ActionListener listener) {
        JPopupMenu popup = new JPopupMenu();
        MenuProperties.addMenuItems(popup, menuPropertyName, listener);
        return popup;
    }

    public static void addGenericItem(JComponent menu, JComponent item) {
        if (menu instanceof JMenu) {
            JMenu jm = (JMenu)menu;
            if (item == null) {
                jm.addSeparator();
            } else {
                jm.add(item);
            }
        } else {
            JPopupMenu jp = (JPopupMenu)menu;
            if (item == null) {
                jp.addSeparator();
            } else {
                jp.add(item);
            }
        }
    }

    public static void addMenuItems(JComponent menu, String menuPropertyName, ActionListener listener) {
        String menuString = UserProperties.getProperty("menu." + menuPropertyName, null);
        if (menuString == null) {
            ICETracer.traceWithStack("Menu definition property '" + menuPropertyName + "' is not defined.");
            return;
        }
        String[] itemList = StringUtilities.splitString(menuString, ":");
        if (itemList != null) {
            int iIdx = 0;
            while (iIdx < itemList.length) {
                String itemNameStr = "item." + menuPropertyName + "." + itemList[iIdx];
                String itemString = UserProperties.getProperty(itemNameStr, null);
                if (itemString == null) {
                    ICETracer.traceWithStack("Menu definition '" + menuPropertyName + "' is missing item definition property '" + itemNameStr + "'.");
                } else {
                    int colonIdx = itemString.indexOf(58);
                    if (itemString.equals("-")) {
                        MenuProperties.addGenericItem(menu, null);
                    } else if (colonIdx < 0) {
                        ICETracer.traceWithStack("Menu '" + menuPropertyName + "' Item '" + itemNameStr + "' has invalid definition.");
                    } else {
                        String title = itemString.substring(0, colonIdx);
                        String command = itemString.substring(colonIdx + 1);
                        if (command.equals("@")) {
                            JMenu subMenu = new JMenu(title);
                            String subMenuName = menuPropertyName + "." + itemList[iIdx];
                            MenuProperties.addMenuItems(subMenu, subMenuName, listener);
                            MenuProperties.addGenericItem(menu, subMenu);
                        } else if (title.equals("-")) {
                            MenuProperties.addGenericItem(menu, null);
                        } else {
                            JMenuItem mItem = new JMenuItem(title);
                            if (listener != null) {
                                mItem.addActionListener(listener);
                                mItem.setActionCommand(command);
                            }
                            MenuProperties.addGenericItem(menu, mItem);
                        }
                    }
                }
                ++iIdx;
            }
        }
    }
}

