/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ForwardingListener
extends ForwardingConfiguration
implements Runnable {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$forwarding$ForwardingListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingListener = ForwardingListener.class$("com.sshtools.j2ssh.forwarding.ForwardingListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingListener));
    private ConnectionProtocol connection;
    private ServerSocket server;
    private Thread thread;
    private boolean listening;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingListener;

    public ForwardingListener(String string, ConnectionProtocol connectionProtocol, String string2, int n, String string3, int n2) {
        super(string, string2, n, string3, n2);
        log.info((Object)("Creating forwarding listener named '" + string + "'"));
        this.connection = connectionProtocol;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Address to bind: " + this.getAddressToBind()));
            log.debug((Object)("Port to bind: " + String.valueOf(this.getPortToBind())));
            log.debug((Object)("Host to connect: " + string3));
            log.debug((Object)("Port to connect: " + n2));
        }
    }

    public ForwardingListener(ConnectionProtocol connectionProtocol, String string, int n) {
        this(string + ":" + String.valueOf(n), connectionProtocol, string, n, "[Specified by connecting computer]", -1);
    }

    public int getLocalPort() {
        return this.server == null ? -1 : this.server.getLocalPort();
    }

    public boolean isListening() {
        return this.listening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                log.info((Object)("Starting forwarding listener thread for '" + this.name + "'"));
                while (this.state.getValue() == 1) {
                    this.listening = true;
                    Socket socket = this.server.accept();
                    if (this.state.getValue() != 2 && socket != null) {
                        log.info((Object)"Connection accepted, creating forwarding channel");
                        try {
                            ForwardingSocketChannel forwardingSocketChannel = this.createChannel(this.hostToConnect, this.portToConnect, socket);
                            forwardingSocketChannel.bindSocket(socket);
                            if (this.connection.openChannel(forwardingSocketChannel)) {
                                log.info((Object)("Forwarding channel for '" + this.name + "' is open"));
                                continue;
                            }
                            log.warn((Object)("Failed to open forwarding chanel " + this.name));
                            socket.close();
                        }
                        catch (Exception exception) {
                            log.warn((Object)("Failed to open forwarding chanel " + this.name), (Throwable)exception);
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (this.state.getValue() == 1) {
                    log.warn((Object)("Local forwarding listener to " + this.hostToConnect + ":" + String.valueOf(this.portToConnect) + " has failed"), (Throwable)iOException);
                }
                Object var5_7 = null;
                this.stop();
                return;
            }
            Object var5_6 = null;
            this.stop();
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.stop();
            throw throwable;
        }
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    public void start() throws IOException {
        super.start();
        try {
            this.server = new ServerSocket(this.getPortToBind(), 50, InetAddress.getByName(this.getAddressToBind()));
        }
        catch (IOException iOException) {
            super.stop();
            throw iOException;
        }
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread.start();
    }

    public void stop() {
        super.stop();
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            log.warn((Object)"Forwarding listener failed to stop", (Throwable)iOException);
        }
        this.thread = null;
        this.listening = false;
    }

    protected abstract ForwardingSocketChannel createChannel(String var1, int var2, Socket var3) throws ForwardingConfigurationException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

