/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : EnemyM3.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;
import Enemy;

class EnemyM3 extends EnemyKind implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : EnemyM3
 * DESCRIPTION	  :
 *****************************************************************************/
  EnemyM3()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    score    = 50;
    hitsize  = 12 << sl;
    chipposx =	8;
    chipposy =	4;
    chipsize = 32 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.di = 1;
    e.shield = 26;
    e.count = JKobo.Context.getRandom().nextInt() & 0xf;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {

    e.moveEnemyTemplate(3, 128);
    e.di = 1;
    if((e.count--) <= 0)
      {
	e.count = 64;
	if(e.norm < ((JKobo.Context.getScaleParms().getWindowWidth() >> 1) +
		     (chipsize << 2)))
	  {
	    e.shotTemplate8Dir(BOMB2);
	  }
      }
    if(e.shield < 10)
      {
	e.shotTemplate8Dir(ROCK);
	e.state = NOTUSE;
    }

  }

}  /* END OF CLASS : EnemyM3 */


/* END OF FILE : EnemyM3.java */

