/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Pipe2.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;

import Enemy;
import Enemies;
import Manage;
import Space;


class Pipe2 extends EnemyKind implements EnemyDefines, GlobalDefines, MapDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Pipe2
 * DESCRIPTION	  :
 *****************************************************************************/
  Pipe2()
  {

    hitsize  = -1;
    score = chipposx = chipposy = chipsize = 0;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {
    int x1, y1, spr_shift;
    int shift, scrx, scry;
    int spr_size;
    ScaleParms sp;

    sp = JKobo.Context.getScaleParms();
    shift = sp.getEnemyShift();
    scrx = sp.getSpaceWidth();
    scry = sp.getSpaceHeight();
    spr_shift = sp.getSpriteWidthShift();
    spr_size = sp.getSpriteWidth();
    x1 = ((e.x >> shift) & (scrx - 1)) >>> spr_shift;
    y1 = ((e.y >> shift) & (scry - 1)) >>> spr_shift;
    JKobo.Context.getSpace().setChipNumber(x1, y1, 0);
    e.shield = -1;
    e.count = 4;
    switch(e.di)
      {
      case 1:
	e.a = D_MASK;
	e.y -= (spr_size << shift);
	break;
      case 3:
	e.a = L_MASK;
	e.x += (spr_size << shift);
	break;
      case 5:
	e.a = U_MASK;
	e.y += (spr_size << shift);
	break;
      case 7:
	e.a = R_MASK;
	e.x -= (spr_size << shift);
	break;
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {
    int x1, y1, a_next, x_next, y_next;
    int p, shift, wsize, scrx, scry;
    int spr_shift, spr_size;
    Enemies enemies;
    Space space;
    ScaleParms sp;


    enemies = JKobo.Context.getEnemies();
    space = JKobo.Context.getSpace();
    sp = JKobo.Context.getScaleParms();
    wsize = sp.getWindowWidth();
    scrx = sp.getSpaceWidth();
    scry = sp.getSpaceHeight();
    shift = sp.getEnemyShift();
    spr_shift = sp.getSpriteWidthShift();
    spr_size = sp.getSpriteWidth();
    x1 = JKobo.Context.getRandom().nextInt();
    y1 = JKobo.Context.getRandom().nextInt();
    if((e.norm < ((wsize >>> 1) + 32)) && (e.count == 1))
      enemies.make(EXPLOSION, (e.x >> shift) + (x1 >>> 28) - 8,
		   (e.y >> shift) + (y1 >>> 28) - 8, 0, 0, 0);
    if(++e.count < 4)
      return;
    e.count = 0;

    x1 = ((e.x >> shift) & (scrx - 1)) >>> spr_shift;
    y1 = ((e.y >> shift) & (scry - 1)) >>> spr_shift;
    a_next = 0;
    x_next = 0;
    y_next = 0;
    p = space.getChipNumber(x1, y1);
    if(p == 0)
      {
	e.state = NOTUSE;
	return;
      }
    if(e.norm < ((wsize >>> 1) + (spr_size << 1)))
	enemies.make(EXPLOSION, e.x >> shift, e.y >> shift, 0, 0, 0);
    if((p^e.a) == 0)
      {
	JKobo.Context.getManage().addScore(30);
	e.state = NOTUSE;
	enemies.eraseCannon(x1, y1);
	space.setChipNumber(x1, y1, 0);
	return;
      }
    if((p^e.a) == HARD)
      {
	e.state = NOTUSE;
	space.setChipNumber(x1, y1, 0);
	return;
      }
    if((p^e.a) == U_MASK)
      {
	a_next = D_MASK;
	y_next = -(spr_size << shift);
      }
    if((p^e.a) == R_MASK)
      {
	a_next = L_MASK;
	x_next = (spr_size << shift);
      }
    if((p^e.a) == D_MASK)
      {
	a_next = U_MASK;
	y_next = (spr_size << shift);
      }
    if((p^e.a) == L_MASK)
      {
	a_next = R_MASK;
	x_next = -(spr_size << shift);
      }
    space.setChipNumber(x1, y1, 0);
    if(a_next != 0)
      {
	e.x += x_next;
	e.y += y_next;
	e.a  = a_next;
	return;
      }
    p ^= e.a;
    if((p & U_MASK) != 0)
      enemies.make(PIPE2, e.x >> shift, e.y >> shift, 0, 0, 1);
    if((p & R_MASK) != 0)
      enemies.make(PIPE2, e.x >> shift, e.y >> shift, 0, 0, 3);
    if((p & D_MASK) != 0)
      enemies.make(PIPE2, e.x >> shift, e.y >> shift, 0, 0, 5);
    if((p & L_MASK) != 0)
      enemies.make(PIPE2, e.x >> shift, e.y >> shift, 0, 0, 7);
    JKobo.Context.getManage().addScore(10);
    e.state = NOTUSE;

  }

}  /* END OF CLASS : Pipe2 */


/* END OF FILE : Pipe2.java */

