/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Rock.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;
import Enemy;

class Rock extends EnemyKind implements EnemyDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Rock
 * DESCRIPTION	  :
 *****************************************************************************/
  Rock()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    score    = 10;
    hitsize  =	4 << sl;
    chipposx = 11;
    chipposy =	4;
    chipsize = 16 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.count = 500;
    e.shield = 255;
    e.di = ((JKobo.Context.getRandom().nextInt() & 0x7fffffff) % 3) + 1;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {

    return;

  }

}  /* END OF CLASS : Rock */


/* END OF FILE : Rock.java */

