/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import java.io.Serializable;

/* Debug-------------------- */
/**
 * This class is used to control debugging aspects of the game (so only certain things are in debug mode at one time).
 * @author mallette
 */
public final class Debug implements Serializable
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long   serialVersionUID        = 1L;
  /** is the application in debug mode? (just generic debugging not related to a specific sub system) */
  public final static boolean debug                   = false;
  /** are the sounds being debugged? */
  public final static boolean debugSound              = false;
  /** are the images being debugged? */
  public final static boolean debugImage              = false;
  /** are the weapons being debugged? */
  public final static boolean debugWeapon             = false;
  /** are the homing weapons being debugged? */
  public final static boolean debugWeaponHoming       = false;
  /** are the shielded weapons being debugged? */
  public final static boolean debugWeaponShield       = false;
  /** are the shields being debugged? */
  public final static boolean debugShield             = false;
  /** are the items being debugged? */
  public final static boolean debugItem               = false;
  /** is one sprite being debugged (only allow one at a time of each type) to be debugged? */
  public final static boolean debugOneSprite          = false;
  /** are the javoids being debugged? */
  public final static boolean debugJavoid             = false;
  /** are the mine being debugged? */
  public final static boolean debugMine               = false;
  /** are the gravit points being debugged? */
  public final static boolean debugGravityPoint       = false;
  /** are the ships being debugged? */
  public final static boolean debugShip               = false;
  /** are the keys being debugged? */
  public final static boolean debugKeyMap             = false;
  /** are the keys being debugged at a low level? */
  public final static boolean debugKeyMapInternal     = false;
  /** are the high scores being debugged? */
  public final static boolean debugHighScores         = false;
  /** are the high scores being debugged at a low level? */
  public final static boolean debugHighScoresInternal = false;
  /** is the user's home directory being debugged? */
  public final static boolean debugUserHome           = false;
  /** are javoids allowed to be created? */
  public final static boolean CreateJavoid            = true;
  /** are singularities allowed to be created? */
  public final static boolean CreateSingularity       = true;
  /** are javoids allowed to be created from white holes? */
  public final static boolean CreateSingularityJavoid = true;
  /** are ships allowed to be created? */
  public final static boolean CreateShip              = true;
  /** are power ups allowed to be created? */
  public final static boolean CreatePowerUp           = true;
  /** are mines allowed to be created? */
  public final static boolean CreateMine              = true;
}
/* Debug-------------------- */
