/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import static javoids.ImageMap.Name.AFTERBURNER1;
import static javoids.ImageMap.Name.ANGEL1;
import static javoids.ImageMap.Name.ANGEL2;
import static javoids.ImageMap.Name.BOMB1;
import static javoids.ImageMap.Name.BOMB2;
import static javoids.ImageMap.Name.BULLET1;
import static javoids.ImageMap.Name.BULLET2;
import static javoids.ImageMap.Name.EMBLEM1;
import static javoids.ImageMap.Name.EXPLOSION1;
import static javoids.ImageMap.Name.GALAXY1;
import static javoids.ImageMap.Name.HBULLET1;
import static javoids.ImageMap.Name.HBULLET2;
import static javoids.ImageMap.Name.HEMBLEM1;
import static javoids.ImageMap.Name.HLASER1;
import static javoids.ImageMap.Name.HMACHINEGUN1;
import static javoids.ImageMap.Name.HMISSILE1;
import static javoids.ImageMap.Name.HMISSILE2;
import static javoids.ImageMap.Name.HMISSILE3;
import static javoids.ImageMap.Name.HMULTIMACHINEGUN1;
import static javoids.ImageMap.Name.HPACMAN_DOT;
import static javoids.ImageMap.Name.JAVOID1;
import static javoids.ImageMap.Name.LASER1;
import static javoids.ImageMap.Name.MACHINEGUN1;
import static javoids.ImageMap.Name.MINE1;
import static javoids.ImageMap.Name.MISC_CROSSHAIR;
import static javoids.ImageMap.Name.MISC_INFINITE;
import static javoids.ImageMap.Name.MISC_KEYBOARD;
import static javoids.ImageMap.Name.MISC_SOUND;
import static javoids.ImageMap.Name.MISSILE1;
import static javoids.ImageMap.Name.MISSILE2;
import static javoids.ImageMap.Name.MISSILE3;
import static javoids.ImageMap.Name.MULTIMACHINEGUN1;
import static javoids.ImageMap.Name.NO_IMAGE;
import static javoids.ImageMap.Name.PACMAN_DOT;
import static javoids.ImageMap.Name.PACMAN_EATABLE_GHOST;
import static javoids.ImageMap.Name.PACMAN_FRUIT;
import static javoids.ImageMap.Name.PACMAN_GHOST;
import static javoids.ImageMap.Name.PACMAN_PACMAN;
import static javoids.ImageMap.Name.PACMAN_POWERPILL;
import static javoids.ImageMap.Name.POWERUP1;
import static javoids.ImageMap.Name.SBULLET1;
import static javoids.ImageMap.Name.SBULLET2;
import static javoids.ImageMap.Name.SEMBLEM1;
import static javoids.ImageMap.Name.SHBULLET1;
import static javoids.ImageMap.Name.SHBULLET2;
import static javoids.ImageMap.Name.SHEMBLEM1;
import static javoids.ImageMap.Name.SHIELD1;
import static javoids.ImageMap.Name.SHIELD2;
import static javoids.ImageMap.Name.SHIP1;
import static javoids.ImageMap.Name.SHLASER1;
import static javoids.ImageMap.Name.SHMACHINEGUN1;
import static javoids.ImageMap.Name.SHMISSILE1;
import static javoids.ImageMap.Name.SHMISSILE2;
import static javoids.ImageMap.Name.SHMISSILE3;
import static javoids.ImageMap.Name.SHMULTIMACHINEGUN1;
import static javoids.ImageMap.Name.SHPACMAN_DOT;
import static javoids.ImageMap.Name.SLASER1;
import static javoids.ImageMap.Name.SMACHINEGUN1;
import static javoids.ImageMap.Name.SMISSILE1;
import static javoids.ImageMap.Name.SMISSILE2;
import static javoids.ImageMap.Name.SMISSILE3;
import static javoids.ImageMap.Name.SMULTIMACHINEGUN1;
import static javoids.ImageMap.Name.SPACMAN_DOT;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.IllegalFormatException;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

/* ImageMap------------------- */
/**
 * A class to load images mapped to an enum name for the items in this game.
 * @author mallette
 */
public class ImageMap extends Thread implements Serializable
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long serialVersionUID = 1L;

  /**
   * An enum for each item name.
   * @author mallette
   */
  public enum Name
  {
    /** this represents when no image is used */
    NO_IMAGE,
    /** a flaming jet (afterburning it's fuel) */
    AFTERBURNER1,
    /** unused at the moment */
    ANGEL1,
    /** unused at the moment */
    ANGEL2,
    /** bomb */
    BOMB1,
    /** mega-bomb */
    BOMB2,
    /** glowing red bullet (was, have to fix gif) */
    BULLET1,
    /** gray bullet */
    BULLET2,
    /** special emblem for omnidirectional gun */
    EMBLEM1,
    /** explosion */
    EXPLOSION1,
    /** swirling galaxy used for background */
    GALAXY1,
    /** a regular javoid */
    JAVOID1,
    /** a laser */
    LASER1,
    /** a machinegun */
    MACHINEGUN1,
    /** a mine (need a 3d animated gif) */
    MINE1,
    /** crosshair for mouse move */
    MISC_CROSSHAIR,
    /** inifity sign for unlimited ammo */
    MISC_INFINITE,
    /** a keyboard */
    MISC_KEYBOARD,
    /** "sound waves" need better image */
    MISC_SOUND,
    /** a missile */
    MISSILE1,
    /** another missile */
    MISSILE2,
    /** yet another missile */
    MISSILE3,
    /** multiple machinegun */
    MULTIMACHINEGUN1,
    /** a pacman dot */
    PACMAN_DOT,
    /** a pacman ghost (blue) that can be eaten */
    PACMAN_EATABLE_GHOST,
    /** a pacman cherry fruit */
    PACMAN_FRUIT,
    /** a pacman ghost */
    PACMAN_GHOST,
    /** a pacman */
    PACMAN_PACMAN,
    /** a pacman power pill */
    PACMAN_POWERPILL,
    /** a powerup (growing/shrinking star) */
    POWERUP1,
    /** sheild (used for toolbar) */
    SHIELD1,
    /** unused at the moment */
    SHIELD2,
    /** the typical ship */
    SHIP1,
    /** homing version of bullet1 (for toolbar) */
    HBULLET1,
    /** homing version of bullet2 (for toolbar) */
    HBULLET2,
    /** homing version of emblem1 (for toolbar) */
    HEMBLEM1,
    /** homing version of laser1 (for toolbar) */
    HLASER1,
    /** homing version of machinegun1 (for toolbar) */
    HMACHINEGUN1,
    /** homing version of missile1 (for toolbar) */
    HMISSILE1,
    /** homing version of missile2 (for toolbar) */
    HMISSILE2,
    /** homing version of missile3 (for toolbar) */
    HMISSILE3,
    /** homing version of multmachinegun1 (for toolbar) */
    HMULTIMACHINEGUN1,
    /** homing version of pacman_dot1 (for toolbar) */
    HPACMAN_DOT,
    /** shielded version of bullet1 (for toolbar) */
    SBULLET1,
    /** shielded version of bullet2 (for toolbar) */
    SBULLET2,
    /** shielded version of emblem1 (for toolbar) */
    SEMBLEM1,
    /** shielded version of laser1 (for toolbar) */
    SLASER1,
    /** shielded version of machinegun1 (for toolbar) */
    SMACHINEGUN1,
    /** shielded version of missile1 (for toolbar) */
    SMISSILE1,
    /** shielded version of missile2 (for toolbar) */
    SMISSILE2,
    /** shielded version of missile3 (for toolbar) */
    SMISSILE3,
    /** shielded version of multimachinegun1 (for toolbar) */
    SMULTIMACHINEGUN1,
    /** shielded version of pacman dot (for toolbar) */
    SPACMAN_DOT,
    /** shielded homing version of bullet1 (for toolbar) */
    SHBULLET1,
    /** shielded homing version of bullet2 (for toolbar) */
    SHBULLET2,
    /** shielded homing version of emblem1 (for toolbar) */
    SHEMBLEM1,
    /** shielded homing version of laser1 (for toolbar) */
    SHLASER1,
    /** shielded homing version of machinegun1 (for toolbar) */
    SHMACHINEGUN1,
    /** shielded homing version of missile1 (for toolbar) */
    SHMISSILE1,
    /** shielded homing version of missile2 (for toolbar) */
    SHMISSILE2,
    /** shielded homing version of missile3 (for toolbar) */
    SHMISSILE3,
    /** shielded homing version of multimachinegun1 (for toolbar) */
    SHMULTIMACHINEGUN1,
    /** shielded homing version of pacman dot (for toolbar) */
    SHPACMAN_DOT
  }

  /** a mapping of image names to image file names */
  private static HashMap<Name,String>    imageNames = new HashMap<Name,String>();
  /** a mapping of image names to the loaded images */
  private static HashMap<Name,Image>     images = new HashMap<Name,Image>();
  /** a mapping of image names to the created icons based on the loaded images */
  private static HashMap<Name,ImageIcon> imageIcons = new HashMap<Name,ImageIcon>();

  static
  {
    ImageMap.imageNames.put(NO_IMAGE,null);
    ImageMap.imageNames.put(AFTERBURNER1,Messages.getString("ImageMap.AfterBurner")); //$NON-NLS-1$
    ImageMap.imageNames.put(ANGEL1,Messages.getString("ImageMap.Angel1")); //$NON-NLS-1$
    ImageMap.imageNames.put(ANGEL2,Messages.getString("ImageMap.Angel2")); //$NON-NLS-1$
    ImageMap.imageNames.put(BOMB1,Messages.getString("ImageMap.Bomb1")); //$NON-NLS-1$
    ImageMap.imageNames.put(BOMB2,Messages.getString("ImageMap.Bomb2")); //$NON-NLS-1$
    ImageMap.imageNames.put(BULLET1,Messages.getString("ImageMap.Bullet1")); //$NON-NLS-1$
    ImageMap.imageNames.put(BULLET2,Messages.getString("ImageMap.Bullet2")); //$NON-NLS-1$
    ImageMap.imageNames.put(EMBLEM1,Messages.getString("ImageMap.Emblem1")); //$NON-NLS-1$
    ImageMap.imageNames.put(EXPLOSION1,Messages.getString("ImageMap.Explosion1")); //$NON-NLS-1$
    ImageMap.imageNames.put(GALAXY1,Messages.getString("ImageMap.Galaxy1")); //$NON-NLS-1$
    ImageMap.imageNames.put(JAVOID1,Messages.getString("ImageMap.Javoid1")); //$NON-NLS-1$
    ImageMap.imageNames.put(LASER1,Messages.getString("ImageMap.Laser1")); //$NON-NLS-1$
    ImageMap.imageNames.put(MACHINEGUN1,Messages.getString("ImageMap.Machinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(MINE1,Messages.getString("ImageMap.Mine1")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISC_CROSSHAIR,Messages.getString("ImageMap.MiscCrosshair")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISC_INFINITE,Messages.getString("ImageMap.MiscInfinite")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISC_KEYBOARD,Messages.getString("ImageMap.MiscKeyboard")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISC_SOUND,Messages.getString("ImageMap.MiscSound")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISSILE1,Messages.getString("ImageMap.Missile1")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISSILE2,Messages.getString("ImageMap.Missile2")); //$NON-NLS-1$
    ImageMap.imageNames.put(MISSILE3,Messages.getString("ImageMap.Missile3")); //$NON-NLS-1$
    ImageMap.imageNames.put(MULTIMACHINEGUN1,Messages.getString("ImageMap.MultiMachinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(PACMAN_DOT,Messages.getString("ImageMap.PacmanDot")); //$NON-NLS-1$
    ImageMap.imageNames.put(PACMAN_EATABLE_GHOST,Messages.getString("ImageMap.PacmanEatableGhost")); //$NON-NLS-1$
    ImageMap.imageNames.put(PACMAN_FRUIT,Messages.getString("ImageMap.PacmanFruit")); //$NON-NLS-1$
    ImageMap.imageNames.put(PACMAN_GHOST,Messages.getString("ImageMap.PacmanGhost")); //$NON-NLS-1$
    ImageMap.imageNames.put(PACMAN_PACMAN,Messages.getString("ImageMap.PacmanPacman")); //$NON-NLS-1$
    ImageMap.imageNames.put(PACMAN_POWERPILL,Messages.getString("ImageMap.PacmanPowerPill")); //$NON-NLS-1$
    ImageMap.imageNames.put(POWERUP1,Messages.getString("ImageMap.PowerUp1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHIELD1,Messages.getString("ImageMap.Shield1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHIELD2,Messages.getString("ImageMap.Shield2")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHIP1,Messages.getString("ImageMap.Ship1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HBULLET1,Messages.getString("ImageMap.HBullet1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HBULLET2,Messages.getString("ImageMap.HBullet2")); //$NON-NLS-1$
    ImageMap.imageNames.put(HEMBLEM1,Messages.getString("ImageMap.HEmblem1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HLASER1,Messages.getString("ImageMap.HLaser1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HMACHINEGUN1,Messages.getString("ImageMap.HMachinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HMISSILE1,Messages.getString("ImageMap.HMissile1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HMISSILE2,Messages.getString("ImageMap.HMissile2")); //$NON-NLS-1$
    ImageMap.imageNames.put(HMISSILE3,Messages.getString("ImageMap.HMissile3")); //$NON-NLS-1$
    ImageMap.imageNames.put(HMULTIMACHINEGUN1,Messages.getString("ImageMap.HMultiMachinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(HPACMAN_DOT,Messages.getString("ImageMap.HPacmanDot")); //$NON-NLS-1$
    ImageMap.imageNames.put(SBULLET1,Messages.getString("ImageMap.SBullet1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SBULLET2,Messages.getString("ImageMap.SBullet2")); //$NON-NLS-1$
    ImageMap.imageNames.put(SEMBLEM1,Messages.getString("ImageMap.SEmblem1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SLASER1,Messages.getString("ImageMap.SLaser1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SMACHINEGUN1,Messages.getString("ImageMap.SMachinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SMISSILE1,Messages.getString("ImageMap.SMissile1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SMISSILE2,Messages.getString("ImageMap.SMissile2")); //$NON-NLS-1$
    ImageMap.imageNames.put(SMISSILE3,Messages.getString("ImageMap.SMissile3")); //$NON-NLS-1$
    ImageMap.imageNames.put(SMULTIMACHINEGUN1,Messages.getString("ImageMap.SMultiMachinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SPACMAN_DOT,Messages.getString("ImageMap.SPacmanDot")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHBULLET1,Messages.getString("ImageMap.SHBullet1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHBULLET2,Messages.getString("ImageMap.SHBullet2")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHEMBLEM1,Messages.getString("ImageMap.SHEmblem1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHLASER1,Messages.getString("ImageMap.SHLaser1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHMACHINEGUN1,Messages.getString("ImageMap.SHMachineGun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHMISSILE1,Messages.getString("ImageMap.SHMissile1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHMISSILE2,Messages.getString("ImageMap.SHMissile2")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHMISSILE3,Messages.getString("ImageMap.SHMissile3")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHMULTIMACHINEGUN1,Messages.getString("ImageMap.SHMultiMachinegun1")); //$NON-NLS-1$
    ImageMap.imageNames.put(SHPACMAN_DOT,Messages.getString("ImageMap.SHPacmanDot")); //$NON-NLS-1$
  }

  /**
   * Load the images in a separate thread.
   */
  /*
   * (non-Javadoc)
   * @see java.lang.Thread#run()
   */
  @Override
  public void run()
  {
    Name errorName = NO_IMAGE;
    System.out.printf(Messages.getString("ImageMap.GetImages")); //$NON-NLS-1$
    try
    {
      for (Name name : Name.values())
      {
        if (!NO_IMAGE.equals(name))
        {
          errorName = name;
          URL url = this.getClass().getResource(Messages.getString("ImageMap.ImageDirectory") + ImageMap.imageNames.get(name)); //$NON-NLS-1$
          if (Debug.debugImage)
            System.out.printf(Messages.getString("ImageMap.LoadingImage"),url.toString()); //$NON-NLS-1$
          ImageMap.images.put(name,Toolkit.getDefaultToolkit().getImage(url));
          ImageMap.imageIcons.put(name,new ImageIcon(this.getScaledImage(name,15,15,Image.SCALE_DEFAULT)));
        }
      }
    }
    catch (NullPointerException nullPointerException)
    {
      JOptionPane.showMessageDialog(null,Messages.getString("ImageMap.ErrorMissingFile") + Messages.getString("ImageMap.ImageDirectory") + ImageMap.imageNames.get(errorName) + Messages.getString("ImageMap.ErrorProgramWillNotLoad") + nullPointerException.getMessage(),Messages.getString("ImageMap.ErrorImageFileMissing"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
    }
    catch (IllegalFormatException illegalFormatException)
    {
      JOptionPane.showMessageDialog(null,Messages.getString("ImageMap.ErrorMissingFile") + Messages.getString("ImageMap.ImageDirectory") + ImageMap.imageNames.get(errorName) + Messages.getString("ImageMap.ErrorProgramWillNotLoad") + illegalFormatException.getMessage(),Messages.getString("ImageMap.ErrorFileMissing"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
    }
    System.out.printf(Messages.getString("ImageMap.GotAllImages")); //$NON-NLS-1$
  }

  /**
   * @return the number of images
   */
  public int size()
  {
    return ImageMap.images.size();
  }

  /**
   * @param name the name (enum) of the item
   * @return the image for the provided name
   */
  public Image getImage(Name name)
  {
    return ImageMap.images.get(name);
  }

  /**
   * @param name the name (enum) of the item
   * @return the icon for the provided name
   */
  public ImageIcon getImageIcon(Name name)
  {
    return ImageMap.imageIcons.get(name);
  }

  /**
   * Scale an image from the list
   * @param name the name (enum) of the item
   * @param width the desired width of the images
   * @param height the desired height of the image
   * @param hints image rendering hints (see sun constants)
   * @return the scaled image
   */
  public Image getScaledImage(Name name,int width,int height,int hints)
  {
    return ImageMap.images.get(name).getScaledInstance(width,height,hints);
  }

  /**
   * @return a mapping of image names to images
   */
  public HashMap<Name,Image> getImages()
  {
    return ImageMap.images;
  }

  /**
   * @param name the name (enum) of the item
   * @param image the image to associate with the provided name
   */
  public void putImage(Name name,Image image)
  {
    ImageMap.images.put(name,image);
  }

  /**
   * Provide a String representation of this object.
   * @return String A representation of the object for debugging.
   */
  @Override
  public String toString()
  {
    return String.format(Messages.getString("ImageMap.ToString"),ImageMap.imageNames,ImageMap.images); //$NON-NLS-1$
  }
}
/* ImageMap------------------- */
