/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * A class to hold the system messages from messages.properties.
 * @author mallette
 */
public class Messages
{
  /** the file name that contains all of the resource names and their mapped string values */
  private static final String         BUNDLE_NAME     = "javoids.messages";                   //$NON-NLS-1$
  /** the resource bundle containing the messages */
  private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(Messages.BUNDLE_NAME);

  /**
   * Constructor (default)
   */
  private Messages()
  {
    // do nothing
  }

  /**
   * @param key the key to look-up
   * @return the message associated with that key
   */
  public static String getString(String key)
  {
    try
    {
      return Messages.RESOURCE_BUNDLE.getString(key);
    }
    catch (MissingResourceException e)
    {
      return '!' + key + '!';
    }
  }
}
