/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.DirectFalling;
import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.Hammer;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSprite;
import com.golden.gamedev.util.Utility;
import java.awt.image.BufferedImage;

public class Monkey
extends AnimatedSprite
implements BasicEnemy {
    Mario game;
    int left = 64;
    int right = 64;
    boolean PositiveX = true;
    int JumpTime = 20;
    int ComeDownTime = 40;
    private int Gravity;
    boolean ComeDown = false;
    private int ComeDownFor;
    int HammerThrowTime;

    public Monkey(BufferedImage[] storedImages, int x, int y, Mario g) {
        this.setLocation(x, y);
        this.setImages(storedImages);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setID(108);
        this.game = g;
        this.left = x - 32;
        this.right = x + 32;
        this.JumpTime = Utility.getRandom(3, 6) * 20;
        this.ComeDownTime = Utility.getRandom(3, 6) * 40;
        this.HammerThrowTime = Utility.getRandom(1, 10) * 10;
    }

    public void update(long l) {
        this.HammerThrow();
        this.ComeDown();
        --this.JumpTime;
        if (this.JumpTime < 0) {
            this.Jump();
        }
        if (this.Gravity < 8) {
            ++this.Gravity;
        }
        this.moveY(this.Gravity);
        if (this.getX() < (double)this.left) {
            this.PositiveX = false;
        }
        if (this.getX() > (double)this.right) {
            this.PositiveX = true;
        }
        if (this.PositiveX) {
            this.moveX(-1.0);
        } else {
            this.moveX(1.0);
        }
        this.LookAtMario();
        super.update(l);
    }

    public void CollidedWithBrick_GoToLeft() {
    }

    public void CollidedWithBrick_GoToRight() {
    }

    public int getType() {
        return this.getID();
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY(), this.MariotoRight()));
        this.setActive(false);
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
    }

    public void KilledByFireBall() {
        this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY(), this.MariotoRight()));
        this.setActive(false);
    }

    public void bounce() {
    }

    public void setYloc(double d) {
        if (!this.ComeDown || this.getY() >= 320.0) {
            this.setY(d);
        }
    }

    private void LookAtMario() {
        if (this.game.player.getX() < this.getX()) {
            this.setAnimationFrame(0, 1);
        } else {
            this.setAnimationFrame(4, 5);
        }
    }

    private void Jump() {
        this.Gravity = -16;
        this.JumpTime = Utility.getRandom(3, 6) * 20;
    }

    private void ComeDown() {
        --this.ComeDownTime;
        if (this.ComeDownTime < 0) {
            this.ComeDown = true;
            this.ComeDownFor = 10;
            this.ComeDownTime = Utility.getRandom(3, 6) * 20;
        }
        if (this.ComeDown) {
            --this.ComeDownFor;
        }
        if (this.ComeDownFor < 0) {
            this.ComeDown = false;
        }
    }

    private void HammerThrow() {
        --this.HammerThrowTime;
        if (this.HammerThrowTime < 0) {
            this.HammerThrowTime = Utility.getRandom(1, 10) * 10;
            if (this.game.player.getX() < this.getX()) {
                this.game.HammerGroup.add(new Hammer(this.getX(), this.getY(), true, this.game.bsLoader.getStoredImages("Hammer")));
            } else {
                this.game.HammerGroup.add(new Hammer(this.getX(), this.getY(), false, this.game.bsLoader.getStoredImages("Hammer")));
            }
        }
    }

    public void CollidedWithShell() {
    }

    public void CollidedWithMovingShell() {
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

