/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.TurtelShell;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSprite;

public class MovingTurtelShell
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public int Gravity = 6;
    boolean Standing = true;
    public boolean Green = true;

    MovingTurtelShell(double x, double y, Mario g, boolean b, boolean legsDown, boolean isGreen) {
        super(x, y);
        this.setID(104);
        this.Standing = legsDown;
        this.PositiveX = b;
        this.game = g;
        this.Green = isGreen;
        if (this.Standing) {
            if (this.Green) {
                this.setImages(this.game.bsLoader.getStoredImages("TurtelShellGreenMoving"));
            } else {
                this.setImages(this.game.bsLoader.getStoredImages("TurtelShellRedMoving"));
            }
        } else if (this.Green) {
            this.setImages(this.game.bsLoader.getStoredImages("TurtelShellGreenMovingFlip"));
        } else {
            this.setImages(this.game.bsLoader.getStoredImages("TurtelShellRedMovingFlip"));
        }
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationTimer(new Timer(150));
    }

    public void update(long l) {
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-8.0);
        } else {
            this.moveX(8.0);
        }
        super.update(l);
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        if (this.isOnScreen()) {
            this.game.parent.amitsAudioPlayer.smb_bump.play();
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        if (this.isOnScreen()) {
            this.game.parent.amitsAudioPlayer.smb_bump.play();
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
    }

    public int getType() {
        return this.getID();
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        if (this.Standing) {
            this.game.EnemyGroup.add(new TurtelShell(this.getX(), this.getY(), this.game, this.MariotoRight(), this.Standing, this.Green));
        } else {
            this.game.EnemyGroup.add(new TurtelShell(this.getX(), this.getY(), this.game, this.MariotoRight(), this.Standing, this.Green));
        }
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
        this.setActive(false);
    }

    public void KilledByFireBall() {
        if (this.Green) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
        } else {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
        }
        this.setActive(false);
    }

    public void bounce() {
        this.Gravity = 6;
    }

    public void setYloc(double d) {
        this.setY(d);
    }

    public void CollidedWithShell() {
    }

    public void CollidedWithMovingShell() {
        if (this.Green) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
        } else {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
        }
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            if (this.Green) {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
            } else {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
            }
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            if (this.Green) {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
            } else {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
            }
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.PositiveX = !this.PositiveX;
        this.bounce();
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

