/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.BaseIO;
import com.golden.gamedev.engine.BaseInput;
import com.golden.gamedev.engine.BaseLoader;
import com.golden.gamedev.engine.BaseTimer;
import com.golden.gamedev.engine.input.AWTInput;
import com.golden.gamedev.engine.timer.SystemTimer;
import com.golden.gamedev.funbox.ErrorNotificationDialog;
import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.GameFontManager;
import com.golden.gamedev.object.PlayField;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;

public abstract class Game {
    public static final String GTGE_VERSION = "0.2.4";
    private static final int DEFAULT_FPS = 30;
    public BaseGraphics bsGraphics;
    public BaseIO bsIO;
    public BaseLoader bsLoader;
    public BaseInput bsInput;
    public BaseTimer bsTimer;
    public GameFontManager fontManager;
    private boolean running;
    private boolean finish;
    GameFont fpsFont;
    private boolean initialized;

    public void stop() {
        this.running = false;
    }

    public void finish() {
        this.finish = true;
        this.stop();
    }

    public boolean isFinish() {
        return this.finish;
    }

    public boolean isRunning() {
        return this.running;
    }

    public final void start() {
        if (this.running || this.finish) {
            return;
        }
        this.running = true;
        if (!this.initialized) {
            // empty if block
        }
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        this.startGameLoop();
    }

    private void initialize() {
        this.initEngine();
        System.gc();
        System.runFinalization();
        this.initResources();
    }

    void startGameLoop() {
        System.gc();
        System.runFinalization();
        this.bsTimer.startTimer();
        this.bsTimer.refresh();
        long elapsedTime = 0L;
        block0: while (true) {
            this.update(elapsedTime);
            this.bsInput.update(elapsedTime);
            while (this.running) {
                Graphics2D g = this.bsGraphics.getBackBuffer();
                this.render(g);
                if (!this.bsGraphics.flip()) continue;
                elapsedTime = this.bsTimer.sleep();
                if (elapsedTime <= 100L) continue block0;
                elapsedTime = 100L;
                continue block0;
            }
            break;
        }
        this.bsTimer.stopTimer();
        if (this.finish) {
            this.bsGraphics.cleanup();
            this.notifyExit();
        }
    }

    protected void initEngine() {
        if (this.bsTimer == null) {
            this.bsTimer = new SystemTimer();
        }
        if (this.bsIO == null) {
            this.bsIO = new BaseIO(this.getClass());
        }
        if (this.bsLoader == null) {
            this.bsLoader = new BaseLoader(this.bsIO, Color.MAGENTA);
        }
        if (this.bsInput == null) {
            this.bsInput = new AWTInput(this.bsGraphics.getComponent());
        }
        this.bsTimer.setFPS(30);
        Background.screen = this.bsGraphics.getSize();
        if (this.fontManager == null) {
            this.fontManager = new GameFontManager();
        }
    }

    public abstract void initResources();

    public abstract void update(long var1);

    public abstract void render(Graphics2D var1);

    protected void notifyExit() {
        if (!(this.bsGraphics instanceof Applet)) {
            try {
                System.exit(0);
            }
            catch (Exception e) {}
        } else {
            BufferedImage image;
            final Applet applet = (Applet)((Object)this.bsGraphics);
            BufferedImage src = ImageUtil.createImage(this.getWidth(), this.getHeight());
            Graphics2D g = src.createGraphics();
            try {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setComposite(AlphaComposite.getInstance(3, 0.8f));
                Ellipse2D.Float shape = new Ellipse2D.Float(this.getWidth() / 10, this.getHeight() / 10, this.getWidth() - this.getWidth() / 10 * 2, this.getHeight() - this.getHeight() / 10 * 2);
                g.setClip(shape);
                if (this instanceof GameEngine) {
                    ((GameEngine)this).getCurrentGame().render(g);
                }
                this.render(g);
                g.dispose();
            }
            catch (Exception e) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.dispose();
            }
            BufferedImage converted = null;
            try {
                image = new BufferedImage(src.getWidth(), src.getHeight(), 10);
                Graphics gfx = image.getGraphics();
                gfx.drawImage(src, 0, 0, null);
                gfx.dispose();
                converted = image;
            }
            catch (Throwable e) {
                // empty catch block
            }
            image = converted != null ? converted : src;
            applet.removeAll();
            applet.setIgnoreRepaint(false);
            Canvas canvas = new Canvas(){
                private static final long serialVersionUID = 8493852179266447783L;

                public void paint(Graphics g1) {
                    Graphics2D g = (Graphics2D)g1;
                    g.drawImage((Image)image, 0, 0, null);
                    g.setColor(Color.YELLOW);
                    g.setFont(new Font("Verdana", 1, 12));
                    g.drawString("Game has been ended", 10, 25);
                    g.drawString("Thank you for playing!", 10, 45);
                    g.drawString("Visit http://www.goldenstudios.or.id/", 10, 75);
                    g.drawString("For free game engine!", 10, 95);
                    g.drawString("This game is developed with GTGE v0.2.4", 10, 115);
                }
            };
            canvas.setSize(applet.getSize());
            canvas.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        applet.getAppletContext().showDocument(new URL("http://goldenstudios.or.id/"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            applet.add(canvas);
            applet.repaint();
            canvas.repaint();
        }
    }

    protected void notifyError(Throwable error) {
        new ErrorNotificationDialog(error, this.bsGraphics, this.getClass().getName(), null);
    }

    public int getRandom(int low, int hi) {
        return Utility.getRandom(low, hi);
    }

    public int getWidth() {
        return this.bsGraphics.getSize().width;
    }

    public int getHeight() {
        return this.bsGraphics.getSize().height;
    }

    public BufferedImage takeScreenShot() {
        BufferedImage screen = ImageUtil.createImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = screen.createGraphics();
        this.render(g);
        g.dispose();
        return screen;
    }

    public void takeScreenShot(File f) {
        ImageUtil.saveImage(this.takeScreenShot(), f);
    }

    public void setFPS(int fps) {
        this.bsTimer.setFPS(fps);
    }

    public int getCurrentFPS() {
        return this.bsTimer.getCurrentFPS();
    }

    public int getFPS() {
        return this.bsTimer.getFPS();
    }

    public void drawFPS(Graphics2D g, int x, int y) {
        this.fontManager.getFont("FPS Font").drawString(g, "FPS = " + this.getCurrentFPS() + "/" + this.getFPS(), x, y);
    }

    public int getMouseX() {
        return this.bsInput.getMouseX();
    }

    public int getMouseY() {
        return this.bsInput.getMouseY();
    }

    public boolean checkPosMouse(int x1, int y1, int x2, int y2) {
        return this.getMouseX() >= x1 && this.getMouseY() >= y1 && this.getMouseX() <= x2 && this.getMouseY() <= y2;
    }

    public boolean checkPosMouse(Sprite sprite, boolean pixelCheck) {
        Background bg = sprite.getBackground();
        if (this.getMouseX() < bg.getClip().x || this.getMouseY() < bg.getClip().y || this.getMouseX() > bg.getClip().x + bg.getClip().width || this.getMouseY() > bg.getClip().y + bg.getClip().height) {
            return false;
        }
        double mosx = (double)this.getMouseX() + bg.getX() - (double)bg.getClip().x;
        double mosy = (double)this.getMouseY() + bg.getY() - (double)bg.getClip().y;
        if (pixelCheck) {
            try {
                return (sprite.getImage().getRGB((int)(mosx - sprite.getX()), (int)(mosy - sprite.getY())) & 0xFF000000) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return mosx >= sprite.getX() && mosy >= sprite.getY() && mosx <= sprite.getX() + (double)sprite.getWidth() && mosy <= sprite.getY() + (double)sprite.getHeight();
    }

    public Sprite checkPosMouse(SpriteGroup group, boolean pixelCheck) {
        Sprite[] sprites = group.getSprites();
        int size = group.getSize();
        for (int i = 0; i < size; ++i) {
            if (!sprites[i].isActive() || !this.checkPosMouse(sprites[i], pixelCheck)) continue;
            return sprites[i];
        }
        return null;
    }

    public Sprite checkPosMouse(PlayField field, boolean pixelCheck) {
        SpriteGroup[] groups = field.getGroups();
        int size = groups.length;
        for (int i = 0; i < size; ++i) {
            Sprite s;
            if (!groups[i].isActive() || (s = this.checkPosMouse(groups[i], pixelCheck)) == null) continue;
            return s;
        }
        return null;
    }

    public boolean click() {
        return this.bsInput.isMousePressed(1);
    }

    public boolean rightClick() {
        return this.bsInput.isMousePressed(3);
    }

    public boolean keyDown(int keyCode) {
        return this.bsInput.isKeyDown(keyCode);
    }

    public boolean keyPressed(int keyCode) {
        return this.bsInput.isKeyPressed(keyCode);
    }

    public void hideCursor() {
        this.bsInput.setMouseVisible(false);
    }

    public void showCursor() {
        this.bsInput.setMouseVisible(true);
    }

    public void setMaskColor(Color c) {
        this.bsLoader.setMaskColor(c);
    }

    public BufferedImage getImage(String imagefile, boolean useMask) {
        return this.bsLoader.getImage(imagefile, useMask);
    }

    public BufferedImage getImage(String imagefile) {
        return this.bsLoader.getImage(imagefile);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask) {
        return this.bsLoader.getImages(imagefile, col, row, useMask);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row) {
        return this.bsLoader.getImages(imagefile, col, row);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask, String sequence, int digit) {
        String mapping = imagefile + sequence + digit;
        BufferedImage[] image = this.bsLoader.getStoredImages(mapping);
        if (image == null) {
            BufferedImage[] src = this.getImages(imagefile, col, row, useMask);
            int count = sequence.length() / digit;
            image = new BufferedImage[count];
            for (int i = 0; i < count; ++i) {
                image[i] = src[Integer.parseInt(sequence.substring(i * digit, (i + 1) * digit))];
            }
            this.bsLoader.storeImages(mapping, image);
        }
        return image;
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, String sequence, int digit) {
        return this.getImages(imagefile, col, row, true, sequence, digit);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask, int start, int end) {
        String mapping = start + imagefile + end;
        BufferedImage[] image = this.bsLoader.getStoredImages(mapping);
        if (image == null) {
            BufferedImage[] src = this.getImages(imagefile, col, row, useMask);
            int count = end - start + 1;
            image = new BufferedImage[count];
            for (int i = 0; i < count; ++i) {
                image[i] = src[start + i];
            }
            this.bsLoader.storeImages(mapping, image);
        }
        return image;
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, int start, int end) {
        return this.getImages(imagefile, col, row, true, start, end);
    }
}

