/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.BaseIO;
import com.golden.gamedev.engine.BaseInput;
import com.golden.gamedev.engine.BaseLoader;
import com.golden.gamedev.engine.BaseTimer;
import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.GameFontManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;

public abstract class GameObject {
    public final GameEngine parent;
    public BaseGraphics bsGraphics;
    public BaseIO bsIO;
    public BaseLoader bsLoader;
    public BaseInput bsInput;
    public BaseTimer bsTimer;
    public GameFontManager fontManager;
    private boolean finish;
    private boolean initialized;

    public GameObject(GameEngine parent) {
        this.parent = parent;
        this.grabEngines();
    }

    private void grabEngines() {
        this.bsGraphics = this.parent.bsGraphics;
        this.bsIO = this.parent.bsIO;
        this.bsLoader = this.parent.bsLoader;
        this.bsInput = this.parent.bsInput;
        this.bsTimer = this.parent.bsTimer;
        this.fontManager = this.parent.fontManager;
    }

    public final void start() {
        this.grabEngines();
        GameFont fpsFont = this.parent.fpsFont;
        if (!this.initialized) {
            this.initResources();
            this.initialized = true;
        }
        this.finish = false;
        System.gc();
        System.runFinalization();
        this.bsInput.refresh();
        this.bsTimer.refresh();
        long elapsedTime = 0L;
        block0: while (true) {
            this.update(elapsedTime);
            this.parent.update(elapsedTime);
            this.bsInput.update(elapsedTime);
            while (!this.finish && this.parent.isRunning()) {
                Graphics2D g = this.bsGraphics.getBackBuffer();
                this.render(g);
                this.parent.render(g);
                if (!this.bsGraphics.flip()) continue;
                elapsedTime = this.bsTimer.sleep();
                if (elapsedTime <= 100L) continue block0;
                elapsedTime = 100L;
                continue block0;
            }
            break;
        }
    }

    public void finish() {
        this.finish = true;
    }

    public abstract void initResources();

    public abstract void update(long var1);

    public abstract void render(Graphics2D var1);

    public int getRandom(int low, int hi) {
        return Utility.getRandom(low, hi);
    }

    public int getWidth() {
        return this.bsGraphics.getSize().width;
    }

    public int getHeight() {
        return this.bsGraphics.getSize().height;
    }

    public BufferedImage takeScreenShot() {
        BufferedImage screen = ImageUtil.createImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = screen.createGraphics();
        this.render(g);
        g.dispose();
        return screen;
    }

    public void takeScreenShot(File f) {
        ImageUtil.saveImage(this.takeScreenShot(), f);
    }

    public void setFPS(int fps) {
        this.bsTimer.setFPS(fps);
    }

    public int getCurrentFPS() {
        return this.bsTimer.getCurrentFPS();
    }

    public int getFPS() {
        return this.bsTimer.getFPS();
    }

    public void drawFPS(Graphics2D g, int x, int y) {
        this.fontManager.getFont("FPS Font").drawString(g, "FPS = " + this.getCurrentFPS() + "/" + this.getFPS(), x, y);
    }

    public int getMouseX() {
        return this.bsInput.getMouseX();
    }

    public int getMouseY() {
        return this.bsInput.getMouseY();
    }

    public boolean checkPosMouse(int x1, int y1, int x2, int y2) {
        return this.getMouseX() >= x1 && this.getMouseY() >= y1 && this.getMouseX() <= x2 && this.getMouseY() <= y2;
    }

    public boolean checkPosMouse(Sprite sprite, boolean pixelCheck) {
        Background bg = sprite.getBackground();
        if (this.getMouseX() < bg.getClip().x || this.getMouseY() < bg.getClip().y || this.getMouseX() > bg.getClip().x + bg.getClip().width || this.getMouseY() > bg.getClip().y + bg.getClip().height) {
            return false;
        }
        double mosx = (double)this.getMouseX() + bg.getX() - (double)bg.getClip().x;
        double mosy = (double)this.getMouseY() + bg.getY() - (double)bg.getClip().y;
        if (pixelCheck) {
            try {
                return (sprite.getImage().getRGB((int)(mosx - sprite.getX()), (int)(mosy - sprite.getY())) & 0xFF000000) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return mosx >= sprite.getX() && mosy >= sprite.getY() && mosx <= sprite.getX() + (double)sprite.getWidth() && mosy <= sprite.getY() + (double)sprite.getHeight();
    }

    public boolean click() {
        return this.bsInput.isMousePressed(1);
    }

    public boolean rightClick() {
        return this.bsInput.isMousePressed(3);
    }

    public boolean keyDown(int keyCode) {
        return this.bsInput.isKeyDown(keyCode);
    }

    public boolean keyPressed(int keyCode) {
        return this.bsInput.isKeyPressed(keyCode);
    }

    public void hideCursor() {
        this.bsInput.setMouseVisible(false);
    }

    public void showCursor() {
        this.bsInput.setMouseVisible(true);
    }

    public void setMaskColor(Color c) {
        this.bsLoader.setMaskColor(c);
    }

    public BufferedImage getImage(String imagefile, boolean useMask) {
        return this.bsLoader.getImage(imagefile, useMask);
    }

    public BufferedImage getImage(String imagefile) {
        return this.bsLoader.getImage(imagefile);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask) {
        return this.bsLoader.getImages(imagefile, col, row, useMask);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row) {
        return this.bsLoader.getImages(imagefile, col, row);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask, String sequence, int digit) {
        String mapping = imagefile + sequence + digit;
        BufferedImage[] image = this.bsLoader.getStoredImages(mapping);
        if (image == null) {
            BufferedImage[] src = this.getImages(imagefile, col, row, useMask);
            int count = sequence.length() / digit;
            image = new BufferedImage[count];
            for (int i = 0; i < count; ++i) {
                image[i] = src[Integer.parseInt(sequence.substring(i * digit, (i + 1) * digit))];
            }
            this.bsLoader.storeImages(mapping, image);
        }
        return image;
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, String sequence, int digit) {
        return this.getImages(imagefile, col, row, true, sequence, digit);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask, int start, int end) {
        String mapping = start + imagefile + end;
        BufferedImage[] image = this.bsLoader.getStoredImages(mapping);
        if (image == null) {
            BufferedImage[] src = this.getImages(imagefile, col, row, useMask);
            int count = end - start + 1;
            image = new BufferedImage[count];
            for (int i = 0; i < count; ++i) {
                image[i] = src[start + i];
            }
            this.bsLoader.storeImages(mapping, image);
        }
        return image;
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, int start, int end) {
        return this.getImages(imagefile, col, row, true, start, end);
    }
}

