/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.graphics;

import com.golden.gamedev.engine.BaseGraphics;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;

public class AppletMode
extends Applet
implements BaseGraphics {
    private static final long serialVersionUID = -1032054734907515015L;
    public static final GraphicsDevice DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    public static final GraphicsConfiguration CONFIG = DEVICE.getDefaultConfiguration();
    private Canvas canvas;
    private BufferStrategy strategy;
    private Graphics2D currentGraphics;

    public void start() {
        if (this.strategy == null) {
            boolean bufferCreated;
            this.setIgnoreRepaint(true);
            this.setLayout(null);
            this.canvas = new Canvas(CONFIG);
            this.canvas.setIgnoreRepaint(true);
            this.canvas.setSize(this.getSize());
            this.add(this.canvas);
            this.canvas.setLocation(0, 0);
            int num = 0;
            do {
                bufferCreated = true;
                try {
                    this.canvas.createBufferStrategy(2);
                }
                catch (ClassCastException e) {
                    bufferCreated = false;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException excp) {
                        // empty catch block
                    }
                    if (num++ <= 5) continue;
                    throw e;
                }
            } while (!bufferCreated);
            while (this.strategy == null) {
                try {
                    this.strategy = this.canvas.getBufferStrategy();
                }
                catch (Exception e) {}
            }
            Graphics2D gfx = null;
            while (gfx == null) {
                try {
                    gfx = this.getBackBuffer();
                }
                catch (Exception e) {}
            }
        }
        this.canvas.requestFocus();
    }

    public Graphics2D getBackBuffer() {
        if (this.currentGraphics == null) {
            this.currentGraphics = (Graphics2D)this.strategy.getDrawGraphics();
        }
        return this.currentGraphics;
    }

    public boolean flip() {
        this.currentGraphics.dispose();
        this.currentGraphics = null;
        try {
            this.strategy.show();
            Toolkit.getDefaultToolkit().sync();
            return !this.strategy.contentsLost();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public void cleanup() {
    }

    public void destroy() {
        this.cleanup();
    }

    public Dimension getSize() {
        return super.getSize();
    }

    public Component getComponent() {
        return this.canvas;
    }

    public String getGraphicsDescription() {
        return "Applet Mode [" + this.getSize().width + "x" + this.getSize().height + "] with BufferStrategy";
    }

    public void setWindowTitle(String st) {
    }

    public String getWindowTitle() {
        return "";
    }

    public void setWindowIcon(Image icon) {
    }

    public Image getWindowIcon() {
        return null;
    }
}

