/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.input;

import com.golden.gamedev.engine.input.AWTInput;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.BitSet;

public class EnhancedAWTInput
extends AWTInput {
    private BitSet keyDown = new BitSet();

    public EnhancedAWTInput(Component comp) {
        super(comp);
    }

    protected AWTInput.InputListener createInputListener() {
        return new EnhancedInputListener();
    }

    public void refresh() {
        super.refresh();
        this.keyDown.clear();
    }

    public boolean[] getKeyDown() {
        throw new UnsupportedOperationException("Enhanced AWT Input use BitSet boolean, use getKeyDownBitSet() instead.");
    }

    public BitSet getKeyDownBitSet() {
        return this.keyDown;
    }

    public boolean isKeyDown(int keyCode) {
        return this.keyDown.get(keyCode);
    }

    protected class EnhancedInputListener
    extends AWTInput.InputListener {
        protected EnhancedInputListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (!EnhancedAWTInput.this.keyDown.get(e.getKeyCode())) {
                EnhancedAWTInput.this.keyDown.set(e.getKeyCode());
                EnhancedAWTInput.this.keyPressed[EnhancedAWTInput.this.pressedKey] = e.getKeyCode();
                ++EnhancedAWTInput.this.pressedKey;
            }
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            EnhancedAWTInput.this.keyDown.clear(e.getKeyCode());
            EnhancedAWTInput.this.keyReleased[EnhancedAWTInput.this.releasedKey] = e.getKeyCode();
            ++EnhancedAWTInput.this.releasedKey;
            e.consume();
        }
    }
}

