/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.input;

import com.golden.gamedev.engine.BaseInput;
import com.golden.gamedev.object.Timer;

public class KeyTyped {
    private BaseInput bsInput;
    private Timer repeatDelayTimer;
    private Timer repeatRateTimer;
    private int key;
    private int keyTyped;

    public KeyTyped(BaseInput bsInput, int repeatDelay, int repeatRate) {
        this.bsInput = bsInput;
        this.repeatDelayTimer = new Timer(repeatDelay);
        this.repeatRateTimer = new Timer(repeatRate);
        this.repeatDelayTimer.setActive(false);
        this.keyTyped = Integer.MIN_VALUE;
        this.key = Integer.MIN_VALUE;
    }

    public KeyTyped(BaseInput bsInput) {
        this(bsInput, 450, 40);
    }

    public void update(long elapsedTime) {
        this.keyTyped = this.bsInput.getKeyPressed();
        if (this.keyTyped != Integer.MIN_VALUE) {
            this.key = this.keyTyped;
            this.repeatDelayTimer.setActive(true);
        } else if (this.bsInput.getKeyReleased() == this.key) {
            this.key = Integer.MIN_VALUE;
            this.repeatDelayTimer.setActive(false);
        } else if (this.key != Integer.MIN_VALUE) {
            if (this.repeatDelayTimer.isActive()) {
                if (this.repeatDelayTimer.action(elapsedTime)) {
                    this.repeatDelayTimer.setActive(false);
                    this.repeatRateTimer.refresh();
                    this.keyTyped = this.key;
                }
            } else if (this.repeatRateTimer.action(elapsedTime)) {
                this.keyTyped = this.key;
            }
        }
    }

    public void refresh() {
        this.repeatDelayTimer.refresh();
        this.repeatRateTimer.refresh();
        this.repeatDelayTimer.setActive(false);
        this.keyTyped = Integer.MIN_VALUE;
        this.key = Integer.MIN_VALUE;
    }

    public int getKeyTyped() {
        return this.keyTyped;
    }

    public boolean isKeyTyped(int keyCode) {
        return this.keyTyped == keyCode;
    }

    public long getRepeatDelay() {
        return this.repeatDelayTimer.getDelay();
    }

    public void setRepeatDelay(long delay) {
        this.repeatDelayTimer.setDelay(delay);
    }

    public long getRepeatRate() {
        return this.repeatRateTimer.getDelay();
    }

    public void setRepeatRate(long rate) {
        this.repeatRateTimer.setDelay(rate);
    }
}

