/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;
import java.awt.Rectangle;

public abstract class CollisionBounds
extends CollisionManager {
    public static final int LEFT_COLLISION = 1;
    public static final int RIGHT_COLLISION = 2;
    public static final int TOP_COLLISION = 4;
    public static final int BOTTOM_COLLISION = 8;
    private static final SpriteGroup DUMMY = new SpriteGroup("Dummy");
    private final Rectangle boundary = new Rectangle();
    private Sprite sprite1;
    private int collisionSide;
    private int collisionX1;
    private int collisionY1;
    protected final CollisionRect rect1 = new CollisionRect();

    public CollisionBounds(int x, int y, int width, int height) {
        this.boundary.setBounds(x, y, width, height);
    }

    public CollisionBounds(Background backgr) {
        this.boundary.setBounds(0, 0, backgr.getWidth(), backgr.getHeight());
    }

    public void setCollisionGroup(SpriteGroup group1, SpriteGroup group2) {
        super.setCollisionGroup(group1, DUMMY);
    }

    public void checkCollision() {
        SpriteGroup group1 = this.getGroup1();
        if (!group1.isActive()) {
            return;
        }
        Sprite[] member1 = group1.getSprites();
        int size1 = group1.getSize();
        for (int i = 0; i < size1; ++i) {
            CollisionShape shape1;
            this.sprite1 = member1[i];
            if (!this.sprite1.isActive() || (shape1 = this.getCollisionShape1(this.sprite1)) == null) continue;
            this.collisionSide = 0;
            this.collisionX1 = (int)this.sprite1.getX();
            this.collisionY1 = (int)this.sprite1.getY();
            if (shape1.getX() < (double)this.boundary.x) {
                this.collisionX1 = this.boundary.x;
                this.collisionSide |= 1;
            }
            if (shape1.getY() < (double)this.boundary.y) {
                this.collisionY1 = this.boundary.y;
                this.collisionSide |= 4;
            }
            if (shape1.getX() + (double)shape1.getWidth() > (double)(this.boundary.x + this.boundary.width)) {
                this.collisionX1 = this.boundary.x + this.boundary.width - shape1.getWidth();
                this.collisionSide |= 2;
            }
            if (shape1.getY() + (double)shape1.getHeight() > (double)(this.boundary.y + this.boundary.height)) {
                this.collisionY1 = this.boundary.y + this.boundary.height - shape1.getHeight();
                this.collisionSide |= 8;
            }
            if (this.collisionSide == 0) continue;
            this.collided(this.sprite1);
        }
    }

    public void revertPosition1() {
        this.sprite1.forceX(this.collisionX1);
        this.sprite1.forceY(this.collisionY1);
    }

    public CollisionShape getCollisionShape1(Sprite s1) {
        this.rect1.setBounds(s1.getX(), s1.getY(), s1.getWidth(), s1.getHeight());
        return this.rect1;
    }

    public boolean isCollisionSide(int side) {
        return (this.collisionSide & side) != 0;
    }

    public void setBoundary(int x, int y, int width, int height) {
        this.boundary.setBounds(x, y, width, height);
    }

    public Rectangle getBoundary() {
        return this.boundary;
    }

    public abstract void collided(Sprite var1);
}

