/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static final GraphicsConfiguration CONFIG = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final MediaTracker tracker;
    private static Composite composite;

    private ImageUtil() {
    }

    public static BufferedImage getImage(URL url, int transparency) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            ImageUtil.waitForResource(image);
            BufferedImage buffImage = ImageUtil.createImage(image.getWidth(null), image.getHeight(null), transparency);
            Graphics2D g = buffImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return buffImage;
        }
        catch (Exception e) {
            System.err.println("ERROR: Unable to load Image = " + url);
            e.printStackTrace();
            return ImageUtil.createImage(50, 50);
        }
    }

    public static BufferedImage getImage(URL url) {
        return ImageUtil.getImage(url, 1);
    }

    public static BufferedImage getImage(URL url, Color keyColor) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            ImageUtil.waitForResource(image);
            return ImageUtil.applyMask(image, keyColor);
        }
        catch (Exception e) {
            System.err.println("ERROR: Unable to load Image = " + url);
            e.printStackTrace();
            return ImageUtil.createImage(50, 50);
        }
    }

    public static BufferedImage[] getImages(URL url, int col, int row, int transparency) {
        return ImageUtil.splitImages(ImageUtil.getImage(url, transparency), col, row);
    }

    public static BufferedImage BlackWhite(BufferedImage image) {
        BufferedImage bw = ImageUtil.createImage(image.getWidth(), image.getHeight());
        Graphics2D srcG = image.createGraphics();
        RenderingHints rhs = srcG.getRenderingHints();
        srcG.setRenderingHints(rhs);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp theOp = new ColorConvertOp(cs, rhs);
        theOp.filter(image, bw);
        return bw;
    }

    public static BufferedImage[] getImages(URL url, int col, int row) {
        return ImageUtil.splitImages(ImageUtil.getImage(url), col, row);
    }

    public static BufferedImage[] getImages(URL url, int col, int row, Color keyColor) {
        return ImageUtil.splitImages(ImageUtil.getImage(url, keyColor), col, row);
    }

    public static BufferedImage createImage(int width, int height, int transparency) {
        return CONFIG.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage createImage(int width, int height, Color color) {
        BufferedImage bi = CONFIG.createCompatibleImage(width, height);
        Graphics2D g = bi.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return bi;
    }

    public static BufferedImage createImage(int width, int height) {
        return ImageUtil.createImage(width, height, 1);
    }

    private static void waitForResource(Image image) throws Exception {
        if (image == null) {
            throw new NullPointerException();
        }
        try {
            tracker.addImage(image, 0);
            tracker.waitForAll();
            if ((tracker.statusID(0, true) & 4) != 0) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            tracker.removeImage(image, 0);
            throw e;
        }
    }

    public static BufferedImage applyMask(Image img, Color keyColor) {
        BufferedImage alpha = ImageUtil.createImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g = alpha.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(img, 0, 0, null);
        g.dispose();
        for (int y = 0; y < alpha.getHeight(); ++y) {
            for (int x = 0; x < alpha.getWidth(); ++x) {
                int col = alpha.getRGB(x, y);
                if (col != keyColor.getRGB()) continue;
                alpha.setRGB(x, y, col & 0xFFFFFF);
            }
        }
        return alpha;
    }

    public static BufferedImage[] splitImages(BufferedImage image, int col, int row) {
        int total = col * row;
        int frame = 0;
        int w = image.getWidth() / col;
        int h = image.getHeight() / row;
        BufferedImage[] images = new BufferedImage[total];
        for (int j = 0; j < row; ++j) {
            for (int i = 0; i < col; ++i) {
                int transparency = image.getColorModel().getTransparency();
                images[frame] = ImageUtil.createImage(w, h, transparency);
                Graphics2D g = images[frame].createGraphics();
                g.drawImage(image, 0, 0, w, h, i * w, j * h, (i + 1) * w, (j + 1) * h, null);
                g.dispose();
                ++frame;
            }
        }
        return images;
    }

    public static BufferedImage rotate(BufferedImage src, int angle) {
        int w = src.getWidth();
        int h = src.getHeight();
        int transparency = src.getColorModel().getTransparency();
        BufferedImage image = ImageUtil.createImage(w, h, transparency);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return image;
    }

    public static BufferedImage resize(BufferedImage src, int w, int h) {
        int transparency = src.getColorModel().getTransparency();
        BufferedImage image = ImageUtil.createImage(w, h, transparency);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, w, h, 0, 0, src.getWidth(), src.getHeight(), null);
        g.dispose();
        return image;
    }

    public static BufferedImage TileImage(BufferedImage src, int Times) {
        int transparency = src.getColorModel().getTransparency();
        BufferedImage image = ImageUtil.createImage(src.getWidth() * Times, src.getHeight(), transparency);
        Graphics2D g = image.createGraphics();
        for (int i = 0; i < Times; ++i) {
            g.drawImage(src, null, i * src.getWidth(), 0);
        }
        g.dispose();
        return image;
    }

    public static BufferedImage flipHorizontal(BufferedImage src) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage flipped = ImageUtil.createImage(w, h, src.getColorModel().getTransparency());
        Graphics2D g = flipped.createGraphics();
        g.drawImage(src, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return flipped;
    }

    public static BufferedImage[] flipHorizontal(BufferedImage[] storedImages) {
        BufferedImage[] flipped = new BufferedImage[storedImages.length];
        for (int i = 0; i < flipped.length; ++i) {
            flipped[i] = ImageUtil.flipHorizontal(storedImages[i]);
        }
        return flipped;
    }

    public static BufferedImage flipVertical(BufferedImage src) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage flipped = ImageUtil.createImage(w, h, src.getColorModel().getTransparency());
        Graphics2D g = flipped.createGraphics();
        g.drawImage(src, 0, 0, w, h, 0, h, w, 0, null);
        g.dispose();
        return flipped;
    }

    public static void saveImage(BufferedImage image, File imagefile) {
        try {
            ImageIO.write((RenderedImage)image, "png", imagefile);
        }
        catch (IOException e) {
            System.err.println("ERROR: unable to save = " + imagefile);
            e.printStackTrace();
        }
    }

    public static byte[] toByteArray(BufferedImage image, String extension) {
        if (image != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                ImageIO.write((RenderedImage)image, extension, baos);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.toString());
            }
            byte[] b = baos.toByteArray();
            return b;
        }
        return new byte[0];
    }

    public static BufferedImage fromByteArray(byte[] imagebytes) {
        try {
            if (imagebytes != null && imagebytes.length > 0) {
                BufferedImage im = ImageIO.read(new ByteArrayInputStream(imagebytes));
                return im;
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static void saveComposite(Graphics2D g) {
        composite = g.getComposite();
    }

    public static void loadComposite(Graphics2D g) {
        g.setComposite(composite);
        composite = null;
    }

    public static void setTransparent(Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(3, alpha));
    }

    static {
        Canvas canvas = new Canvas();
        tracker = new MediaTracker(canvas);
    }
}

