/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Angle;
import biege.Element;
import biege.GUI;
import biege.Player;
import biege.Position;
import biege.TextBox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class Player2
extends Element {
    private static double xStep = 2.9;
    private static double yStep = 2.6;
    private boolean smiting = false;
    private static boolean readyToSmite = true;
    private static double STRIKE_REACH = 4.1;
    private static Image[] sprites = new Image[16];
    private Image currentSprite;
    private static int STAB_FRAME = 3;
    private Angle frameCount = new Angle(0.0);
    private static int MAX_HEALTH = 3;
    private int invincibility = 0;
    private int direction = Position.DIRECTION_SOUTH;
    private double gurth = 2.1;
    private int width = 8;
    private int height = 12;
    private int health;
    private Position facing;

    public Player2(Position p) {
        super(p);
        this.facing = p;
        this.invincibility = 0;
        this.loadAllSprites();
        this.direction = Position.DIRECTION_SOUTH;
        this.health = MAX_HEALTH;
    }

    public void talk(GUI tempGui) {
        if (this.isDead()) {
            return;
        }
        String[] temp = new String[]{"Hey ya buddy"};
        tempGui.setTextBox(new TextBox(temp));
    }

    private void loadAllSprites() {
        Player2.sprites[Position.DIRECTION_NORTH] = Element.loadImage("temp_north_2.gif");
        Player2.sprites[1] = Element.loadImage("temp_north_1.gif");
        Player2.sprites[2] = Element.loadImage("temp_north_3.gif");
        Player2.sprites[3] = Element.loadImage("temp_north_4.gif");
        Player2.sprites[Position.DIRECTION_SOUTH] = Element.loadImage("temp_south_2.gif");
        Player2.sprites[5] = Element.loadImage("temp_south_1.gif");
        Player2.sprites[6] = Element.loadImage("temp_south_3.gif");
        Player2.sprites[7] = Element.loadImage("temp_south_4.gif");
        Player2.sprites[Position.DIRECTION_EAST] = Element.loadImage("temp_east_2.gif");
        Player2.sprites[9] = Element.loadImage("temp_east_1.gif");
        Player2.sprites[10] = Element.loadImage("temp_east_3.gif");
        Player2.sprites[11] = Element.loadImage("temp_east_4.gif");
        Player2.sprites[Position.DIRECTION_WEST] = Element.loadImage("temp_west_2.gif");
        Player2.sprites[13] = Element.loadImage("temp_west_1.gif");
        Player2.sprites[14] = Element.loadImage("temp_west_3.gif");
        Player2.sprites[15] = Element.loadImage("temp_west_4.gif");
        this.currentSprite = sprites[this.direction + 1];
    }

    public void draw(Graphics g, int viewW, int viewH) {
        if (this.isDead()) {
            return;
        }
        if (this.invincibility % 2 == 1) {
            return;
        }
        int x = this.scaleX(viewW);
        int y = this.scaleY(viewH);
        if (this.currentSprite != null) {
            Element.drawImage(this.currentSprite, g, x - Element.scaleWidth(viewW, this.width / 2), y - Element.scaleHeight(viewH, this.height / 2), Element.scaleWidth(viewW, this.width), Element.scaleHeight(viewH, this.height));
        }
        if (this.smiting) {
            if (Player.SWING_SOUND != null) {
                Player.SWING_SOUND.play();
            }
            g.setColor(Color.blue);
            g.drawOval(Element.scaleX(viewW, this.facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH), Element.scaleY(viewH, this.facing.getY()) - Element.scaleHeight(viewH, (int)STRIKE_REACH), Element.scaleWidth(viewW, (int)STRIKE_REACH * 2), Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));
            g.setColor(Color.cyan);
            g.drawOval(Element.scaleX(viewW, this.facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH) + 1, Element.scaleY(viewH, this.facing.getY()) - Element.scaleHeight(viewH, (int)STRIKE_REACH) + 1, Element.scaleWidth(viewW, (int)STRIKE_REACH * 2), Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));
        }
    }

    public int getHealth() {
        return this.health;
    }

    public double getGurth() {
        return this.height / 2;
    }

    public int getDirection() {
        return this.direction;
    }

    public static void getReadyToSmite() {
        readyToSmite = true;
    }

    public void advance(GUI tempGui) {
        if (this.isDead()) {
            return;
        }
        if (this.invincibility > 0) {
            --this.invincibility;
        }
        if (this.smiting) {
            this.smiting = false;
        }
        if (GUI.isShiftPressed() && readyToSmite) {
            this.smite();
        }
        if (GUI.isShiftPressed()) {
            this.currentSprite = sprites[this.direction + STAB_FRAME];
        } else {
            this.handleDirctions(tempGui);
            this.faceDirection();
        }
        Player p = tempGui.getPlayer();
        if (this.smiting && Position.distance(this.facing, p.getPosition()) < STRIKE_REACH + p.getGurth()) {
            p.hurt();
        }
    }

    public void faceDirection() {
        if (this.direction == Position.DIRECTION_NORTH) {
            this.facing = new Position(this.getPosition().getX(), this.getPosition().getY() - 8.5);
        }
        if (this.direction == Position.DIRECTION_SOUTH) {
            this.facing = new Position(this.getPosition().getX(), this.getPosition().getY() + 8.5);
        }
        if (this.direction == Position.DIRECTION_EAST) {
            this.facing = new Position(this.getPosition().getX() + 7.5, this.getPosition().getY());
        }
        if (this.direction == Position.DIRECTION_WEST) {
            this.facing = new Position(this.getPosition().getX() - 7.5, this.getPosition().getY());
        }
    }

    public Position directlyFacing() {
        return this.facing;
    }

    public void hurt() {
        if (this.isDead()) {
            this.invincibility = 0;
            return;
        }
        if (this.invincibility <= 0) {
            if (Player.HURT_SOUND != null) {
                Player.HURT_SOUND.play();
            }
            --this.health;
            this.invincibility = Player.HURT_RECOVER;
        }
    }

    public boolean isDead() {
        return this.health <= 0;
    }

    public void fullHeal() {
        this.invincibility = 0;
        Player2.getReadyToSmite();
        this.health = MAX_HEALTH;
    }

    private void flipFrame() {
        int frame = 0;
        this.frameCount.increment(1.5707963267948966);
        frame = this.direction + (int)Math.sin(this.frameCount.get()) + 1;
        this.currentSprite = sprites[frame];
    }

    private void handleDirctions(GUI tempGui) {
        boolean shouldFlip = this.smiting;
        double dx = 0.0;
        double dy = 0.0;
        if (GUI.isWPressed()) {
            dy = -yStep;
            this.direction = Position.DIRECTION_NORTH;
            shouldFlip = true;
        }
        if (GUI.isAPressed()) {
            dx = -xStep;
            this.direction = Position.DIRECTION_WEST;
            shouldFlip = true;
        }
        if (GUI.isDPressed()) {
            dx = xStep;
            this.direction = Position.DIRECTION_EAST;
            shouldFlip = true;
        }
        if (GUI.isSPressed()) {
            dy = yStep;
            this.direction = Position.DIRECTION_SOUTH;
            shouldFlip = true;
        }
        if (shouldFlip) {
            this.changePosition(new Position(this.getPosition().getX() + dx, this.getPosition().getY() + dy));
            this.flipFrame();
        } else {
            this.currentSprite = sprites[this.direction + 1];
        }
    }

    private void smite() {
        readyToSmite = false;
        this.smiting = true;
    }

    public void interact(Element e) {
        if (this.isDead()) {
            return;
        }
        if (this.smiting && e.isBad() && Position.distance(this.facing, e.getPosition()) < STRIKE_REACH + e.getGurth()) {
            e.delete();
        }
    }
}

