/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.AdventureApp;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class Position {
    public static int DIRECTION_NORTH = 0;
    public static int DIRECTION_SOUTH = 4;
    public static int DIRECTION_EAST = 8;
    public static int DIRECTION_WEST = 12;
    private Point2D point;
    private static final String pattern = "######.##";
    private static final double EPSILON = 1.0E-4;
    private static final double DELTA = 0.025;
    private static double ma;
    private static double mb;
    private static double mc;
    private static final DecimalFormat myFormatter;

    public static double boundX(double x) {
        if (x - 1.0E-4 < (double)AdventureApp.LEFT) {
            return AdventureApp.LEFT;
        }
        if (x + 1.0E-4 > (double)AdventureApp.RIGHT) {
            return AdventureApp.RIGHT;
        }
        return x;
    }

    public static double boundY(double y) {
        if (y - 1.0E-4 < (double)AdventureApp.TOP) {
            return AdventureApp.TOP;
        }
        if (y + 1.0E-4 > (double)AdventureApp.BOTTOM) {
            return AdventureApp.BOTTOM;
        }
        return y;
    }

    public Position(double newX, double newY) {
        this.point = new Point2D.Double(newX, newY);
    }

    public Position() {
        this(0.0, 0.0);
    }

    public Position(Position newPosition) {
        this(newPosition.getX(), newPosition.getY());
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    public Position getLocation() {
        return new Position(this.getX(), this.getY());
    }

    public static Position closestRectangleIntersection(Position p, double west, double north, double east, double south) {
        Position temp;
        double x = p.getX();
        double y = p.getY();
        Position closest = temp = new Position(east, y);
        temp = new Position(west, y);
        if (Position.distance(temp, p) < Position.distance(closest, p)) {
            closest = temp;
        }
        if (Position.distance(temp = new Position(x, north), p) < Position.distance(closest, p)) {
            closest = temp;
        }
        if (Position.distance(temp = new Position(x, south), p) < Position.distance(closest, p)) {
            closest = temp;
        }
        return closest;
    }

    public void setLocation(double newX, double newY) {
        this.point.setLocation(newX, newY);
    }

    public void setLocation(Position newPosition) {
        this.point.setLocation(newPosition.getX(), newPosition.getY());
    }

    public double distance(Position otherLocation) {
        return this.point.distance(otherLocation.point);
    }

    public double distance(double x, double y) {
        return this.point.distance(x, y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Point2D.distance(x1, y1, x2, y2);
    }

    public static double distance(Position p1, Position p2) {
        return Point2D.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static Position calculateDirectionVector(Position currentLocation, Position goalLocation) {
        double distance = Position.distance(currentLocation, goalLocation);
        double xCoord = (goalLocation.getX() - currentLocation.getX()) / distance;
        double yCoord = (goalLocation.getY() - currentLocation.getY()) / distance;
        return new Position(xCoord, yCoord);
    }

    public static boolean isInRectangle(Position testPos, Position topLeft, Position bottomRight) {
        return testPos.getX() > topLeft.getX() && testPos.getX() < bottomRight.getX() && testPos.getY() > topLeft.getY() && testPos.getY() < bottomRight.getY();
    }

    public static Position calculateVelocityVector(Position direction, double speed) {
        return new Position(direction.getX() * speed, direction.getY() * speed);
    }

    public static Position calculateNewPosition(Position currentLocation, Position velocity) {
        double x = currentLocation.getX() + velocity.getX();
        double y = currentLocation.getY() + velocity.getY();
        return new Position(x, y);
    }

    public static Position calculateNewPosition(Position currentLocation, Position goalLocation, double speed) {
        Position directionVector = Position.calculateDirectionVector(currentLocation, goalLocation);
        Position velocityVector = Position.calculateVelocityVector(directionVector, speed);
        Position newPosition = Position.calculateNewPosition(currentLocation, velocityVector);
        if (currentLocation.distance(goalLocation) <= currentLocation.distance(newPosition)) {
            newPosition = goalLocation;
        }
        return newPosition;
    }

    private static int pythagorean(double a, double b, double c, Position results) {
        int numResults = 0;
        double dDiscr = b * b - (double)4 * a * c;
        double s1 = -b / ((double)2 * a);
        double s2 = 0.0;
        if (Math.abs(dDiscr) < 1.0E-4) {
            s1 = -b / ((double)2 * a);
            numResults = 1;
        } else if (dDiscr < 0.0) {
            numResults = 0;
        } else {
            dDiscr = Math.sqrt(dDiscr);
            s1 = (-b + dDiscr) / ((double)2 * a);
            s2 = (-b - dDiscr) / ((double)2 * a);
            numResults = 2;
        }
        results.setLocation(s1, s2);
        return numResults;
    }

    private static Position addPointToVector(Position point, Position vector) {
        double x = point.getX() + vector.getX();
        double y = point.getY() + vector.getY();
        return new Position(x, y);
    }

    private static void makeLineFromTwoPoints(Position p1, Position p2) {
        double dA = 1.0;
        double dB = 0.0;
        double dC = 0.0;
        double dTemp = p2.getX() - p1.getX();
        if (Math.abs(dTemp) < 1.0E-4) {
            dA = 0.0;
            dB = 1.0;
        } else {
            dA = 1.0;
            dB = -(p2.getY() - p1.getY()) / dTemp;
        }
        dC = -dA * p2.getY() - dB * p2.getX();
        ma = dA;
        mb = dB;
        mc = dC;
    }

    public static void calcCircleVectorIntersection(Position center, double radius, Position vector, Position origin, Position result1, Position result2) {
        Position.makeLineFromTwoPoints(origin, Position.addPointToVector(origin, vector));
        Position result = new Position();
        double h = center.getX();
        double k = center.getY();
        if (Math.abs(ma) < 1.0E-4) {
            int iSol = Position.pythagorean(1.0, (double)-2 * k, (-mc / mb - h) * (-mc / mb - h) + k * k - radius * radius, result);
            double dSol1 = result.getX();
            double dSol2 = result.getY();
            result1.setLocation(-mc / mb, dSol1);
            result2.setLocation(-mc / mb, dSol2);
            return;
        }
        double da = -mb / ma;
        double db = -mc / ma;
        double dA = 1.0 + da * da;
        double dB = (double)2 * (da * db - h - k * da);
        double dC = h * h + db * db - (double)2 * k * db + k * k - radius * radius;
        int iSol = Position.pythagorean(dA, dB, dC, result);
        double dSol1 = result.getX();
        double dSol2 = result.getY();
        result1.setLocation(dSol1, da * dSol1 + db);
        result2.setLocation(dSol2, da * dSol2 + db);
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("(").concat(String.valueOf(myFormatter.format(this.getX())))).concat(String.valueOf(", "))).concat(String.valueOf(myFormatter.format(this.getY())))).concat(String.valueOf(")"));
    }

    public static void main(String[] args) {
        Position p1 = new Position(0.0, 90.0);
        Position p2 = new Position(0.0, 100.0);
        double speed = 5.0;
        double distance = Position.distance(p1, p2);
        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p1).concat(String.valueOf(" to "))).concat(String.valueOf(p2))).concat(String.valueOf(" is "))).concat(String.valueOf(distance)));
        Position direction = Position.calculateDirectionVector(p1, p2);
        System.out.println(String.valueOf("direction vector is ").concat(String.valueOf(direction)));
        Position velocity = Position.calculateVelocityVector(direction, speed);
        System.out.println(String.valueOf("velocity vector is ").concat(String.valueOf(velocity)));
        Position newPosition = Position.calculateNewPosition(p1, velocity);
        System.out.println(String.valueOf("new position via method 1 is ").concat(String.valueOf(newPosition)));
        newPosition = Position.calculateNewPosition(p1, p2, speed);
        System.out.println(String.valueOf("new position via method 2 is ").concat(String.valueOf(newPosition)));
        Position circleCenter = new Position(0.0, 0.0);
        double radius = 0.5;
        Position p3 = new Position(0.0, -2.0);
        Position p4 = new Position(1.0, 1.0);
        Position p5 = new Position(1.0, 0.0);
        Position v3 = Position.calculateDirectionVector(p3, circleCenter);
        Position v4 = Position.calculateDirectionVector(p4, circleCenter);
        Position v5 = Position.calculateDirectionVector(p5, circleCenter);
        Position result1 = new Position();
        Position result2 = new Position();
        Position.calcCircleVectorIntersection(circleCenter, radius, v3, p3, result1, result2);
        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Intersections of ").concat(String.valueOf(p3))).concat(String.valueOf(" with circle are: "))).concat(String.valueOf(result1))).concat(String.valueOf(", "))).concat(String.valueOf(result2)));
        Position.calcCircleVectorIntersection(circleCenter, radius, v4, p4, result1, result2);
        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Intersections of ").concat(String.valueOf(p4))).concat(String.valueOf(" with circle are: "))).concat(String.valueOf(result1))).concat(String.valueOf(", "))).concat(String.valueOf(result2)));
        Position.calcCircleVectorIntersection(circleCenter, radius, v5, p5, result1, result2);
        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Intersections of ").concat(String.valueOf(p5))).concat(String.valueOf(" with circle are: "))).concat(String.valueOf(result1))).concat(String.valueOf(", "))).concat(String.valueOf(result2)));
    }

    static {
        myFormatter = new DecimalFormat(pattern);
    }
}

