package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.applet.AudioClip;


public class CrystalGiver extends Folk
{

    private static int WIDTH = 9;
    private static int HEIGHT = 7;

    private static int CRYSTAL_MESSAGE = WorldData.getGiveCrystalMessageIndex();
    private static AudioClip GET_CRYSTAL_SOUND = Element.loadAudioClip("file:sound/get.wav");
    private int crystalId;

    public CrystalGiver(Position p, int id)
    {
      super(new Position(p.getX() - WIDTH/2, p.getY()-HEIGHT/2), CRYSTAL_MESSAGE);
      crystalId = id;
    }


    public void talk (GUI tempGui)
    {
      Player p = tempGui.getPlayer();

      if (!p.hasCystal(crystalId))
      {
        super.talk(tempGui);
        p.giveCrystal(crystalId);
        GET_CRYSTAL_SOUND.play();
      }
      else if (tempGui.getTextBox() == null)
      {
        String[] msg = {"Get lost!", "I already gave you my crystal!"};
        tempGui.setTextBox(new TextBox(msg));
      }
    }

    public double getGurth()
    {
      return (double)WIDTH;
    }

    public void delete() {}

}