package biege;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.net.URL;
import java.net.MalformedURLException;
import java.awt.Toolkit;
import java.security.AccessControlException;
import java.lang.InterruptedException;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.net.MalformedURLException;
import java.applet.Applet;
import java.applet.AudioClip;


public abstract class Element extends Object
{

  private Position location;
  private boolean shouldVanish = false;
  private static String IMAGE_PATH = "images/";
  private static int modelW = AdventureApp.RIGHT - AdventureApp.LEFT;
  private static int modelH = AdventureApp.BOTTOM - AdventureApp.TOP;


  public Element(Position p)
  {
    super();
    location = p;
  }

  public static AudioClip loadAudioClip (String soundLocation)
  {
      try
      {
        URL temp = new URL(soundLocation);
        return Applet.newAudioClip(temp);
      }
      catch (MalformedURLException e)
      {
        return null;
      }
  }

          /** Loads an image from the specified file name.
    @param imgLocation  The location of an image file.
    @return Returns an image. */
    public static Image loadImage (String imgName)
    {
          Toolkit tk = Toolkit.getDefaultToolkit();
          Image i;
          try   //Checks if image is legitamite
          {

                    i = tk.getImage(IMAGE_PATH + imgName);
          }
          catch (AccessControlException e)
          {
            System.out.println("Could not load image " + imgName);
            return null;
          }
          return i;
    }

  public static void drawImage (Image i, Graphics g, int x, int y, int w, int h)
  {
    DummyObserver o  = new DummyObserver();
    if (i != null)
    {
      g.drawImage(i, x, y, w, h, o);
    }

  }



  public void changePosition(Position p)
  {
    p = new Position(Position.boundX(p.getX()), Position.boundY(p.getY()));
    location = p;
  }

  public int countCrystals ()
  {
    return 0;
  }

  public Position getPosition()
  {
    return location;
  }

  public int scaleX(int viewW)
  {
    int x = (int)location.getX();
    return (int)(x*viewW/modelW);
  }

  public static int scaleWidth(int viewW, int width)
  {
    return (int)(width*viewW/modelW);
  }

  public static  int scaleHeight(int viewH, int height)
  {
    return (int)(height*viewH/modelH);
  }

  public static int scaleX(int viewW, double oldX)
  {
    int x = (int)oldX;
    return (int)(x*viewW/modelW);
  }

  public void playSound(int i) {}

  public static int scaleY(int viewH, double oldY)
  {
    int y= (int)oldY;
    return (int)(y*viewH/modelH);
  }

  public int scaleY(int viewH)
  {
    int y = (int)location.getY();
    return (int)(y*viewH/modelH);
  }

  public void delete()
  {
    shouldVanish = true;
  }

  public void undelete()
  {
    shouldVanish = false;
  }

  public void onDeath (GUI tempGui) { }

  public void talk(GUI tempGui)
  {
        tempGui.setTextBox(TextBox.defaultTextBox());
  }

  public boolean shoulVanish()
  {
    return shouldVanish;
  }

  public abstract void draw(Graphics g, int viewW, int viewH);

  public abstract void interact (Element e);

  public void advance(GUI tempGui) {}

  public void hurt() { }

  public void giveCrystal(int i) { }

  public boolean hasAllCrystals()
  {
    return false;
  }

  public boolean hasCystal(int i)
  {
    return false;
  }

  public double getGurth()
  {
    return 0.0;
  }

  public boolean isSolid()
  {
    return true;
  }

  public boolean isBad()
  {
    return false;
  }



}