package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;


public class Folk extends RectangleObstacle
{

    private static int WIDTH = 9;
    private static int HEIGHT = 12;

    private int dialogueIndex;

    private static String FOLK_IMAGE_LOCATION =  "dwarf.gif";
    private static Image SPRITE;

    public Folk(Position p, int i)
    {
      super(new Position(p.getX() - WIDTH/2, p.getY()-HEIGHT/2), WIDTH, HEIGHT, Color.blue);
      dialogueIndex = i;

      if (SPRITE == null)
      {
        SPRITE = Element.loadImage(FOLK_IMAGE_LOCATION);
      }

    }

    public Folk(Position p, int w, int h, int i)
    {
      super(new Position(p.getX() - w/2, p.getY()-h/2), w, h, Color.blue);
      dialogueIndex = i;

      if (SPRITE == null)
      {
        SPRITE = Element.loadImage(FOLK_IMAGE_LOCATION);
      }

    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      g.setColor(Color.red);
        if(SPRITE != null)
          Element.drawImage(SPRITE, g, scaleX(viewW), scaleY(viewH),
                                                 Element.scaleWidth(viewW, WIDTH), Element.scaleHeight(viewH, HEIGHT));

    }

    public void interact(Element e)
    {
      super.interact(e);
    }

    public void advance(GUI tempGui)
    {
    }

    public void talk (GUI tempGui)
    {

      tempGui.setTextBox(new TextBox(WorldData.getDialogue(dialogueIndex)));
    }

    public double getGurth()
    {
      return (double)WIDTH;
    }

    public void changePosition(Position p) {}//do nothing. Does not move

}