package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;
import java.applet.AudioClip;

public class Player2 extends Element
{
    private static double xStep = 2.9;
    private static double yStep = 2.6;

    private boolean smiting = false;
    private static boolean readyToSmite = true;
    private static double STRIKE_REACH = 4.1;

    private static Image[] sprites = new Image[16];
    private Image currentSprite;
    private static int STAB_FRAME = 3;
    private Angle frameCount = new Angle(0);
    private static int MAX_HEALTH = 3;


    private int invincibility = 0;
    private int direction = Position.DIRECTION_SOUTH;
    private double gurth = 2.1;

    private int width = 8;
    private int height = 12;
    private int health;

    private Position facing;

    public Player2(Position p)
    {

      super(p);
      facing = p;
      invincibility = 0;
      loadAllSprites();
      direction = Position.DIRECTION_SOUTH;
      health = MAX_HEALTH;
    }

    public void talk(GUI tempGui)
    {
      if (this.isDead())
        return;

      String[] temp = {"Hey ya buddy"};
      tempGui.setTextBox(new TextBox(temp));
    }


    private void loadAllSprites()
    {
      sprites[Position.DIRECTION_NORTH] = Element.loadImage("temp_north_2.gif");
      sprites[1] = Element.loadImage("temp_north_1.gif");
      sprites[2] = Element.loadImage("temp_north_3.gif");
      sprites[3] = Element.loadImage("temp_north_4.gif");

      sprites[Position.DIRECTION_SOUTH] = Element.loadImage("temp_south_2.gif");
      sprites[5] = Element.loadImage("temp_south_1.gif");
      sprites[6] = Element.loadImage("temp_south_3.gif");
      sprites[7] = Element.loadImage("temp_south_4.gif");

      sprites[Position.DIRECTION_EAST] = Element.loadImage("temp_east_2.gif");
      sprites[9] = Element.loadImage("temp_east_1.gif");
      sprites[10] = Element.loadImage("temp_east_3.gif");
      sprites[11] = Element.loadImage("temp_east_4.gif");

      sprites[Position.DIRECTION_WEST] = Element.loadImage("temp_west_2.gif");
      sprites[13] = Element.loadImage("temp_west_1.gif");
      sprites[14] = Element.loadImage("temp_west_3.gif");
      sprites[15] = Element.loadImage("temp_west_4.gif");

      currentSprite = sprites[direction + 1];
    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      if (this.isDead())
        return;
      //See if you are flashing snd should be invisible
      if (invincibility % 2 == 1)
        return;

      int x = scaleX(viewW);
      int y = scaleY(viewH);

        if(currentSprite != null)
          Element.drawImage(currentSprite, g, x  -  Element.scaleWidth(viewW, (int)width/2), y -  Element.scaleHeight(viewH, (int)height/2),
                                                 Element.scaleWidth(viewW, width), Element.scaleHeight(viewH, height));

      if (smiting)
      {
        if (Player.SWING_SOUND != null)
          Player.SWING_SOUND.play();

        g.setColor(Color.blue);
        g.drawOval(Element.scaleX(viewW, facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH),
                   Element.scaleY(viewH, facing.getY()) -  Element.scaleHeight(viewH, (int)STRIKE_REACH),
                   Element.scaleWidth(viewW, (int)STRIKE_REACH * 2),  Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));

        g.setColor(Color.cyan);
        g.drawOval(Element.scaleX(viewW, facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH) + 1,
                   Element.scaleY(viewH, facing.getY()) -  Element.scaleHeight(viewH, (int)STRIKE_REACH) + 1,
                   Element.scaleWidth(viewW, (int)STRIKE_REACH * 2),  Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));

      }
    }

    public int getHealth()
    {
      return health;
    }

    public double getGurth()
    {
      return height/2;
    }

    public int getDirection()
    {
      return direction;
    }

    public static void getReadyToSmite()
    {
      readyToSmite = true;
    }

    public void advance(GUI tempGui)
    {
      if (this.isDead())
        return;

      //Cant stay invincible forever
      if (invincibility > 0)
        invincibility--;

      //Do not sing continouosly
      if (smiting)
      {
        smiting = false;
      }

      if (tempGui.isShiftPressed() && readyToSmite)
      {
        smite();
      }

      if (tempGui.isShiftPressed())
        currentSprite = sprites[direction + STAB_FRAME];
      else
        {
          handleDirctions (tempGui);
          faceDirection();

        }
      // /**** Hurt each other HURRAY
      Player p = tempGui.getPlayer();
      if (smiting  && Position.distance(facing, p.getPosition()) < STRIKE_REACH + p.getGurth())
              p.hurt();
      // */
    }//advance


    public void faceDirection()
    {
      if (direction == Position.DIRECTION_NORTH)
        facing = new Position (getPosition().getX(), getPosition().getY() - 8.5);
      if (direction == Position.DIRECTION_SOUTH)
        facing = new Position (getPosition().getX(), getPosition().getY() + 8.5);
      if (direction == Position.DIRECTION_EAST)
        facing = new Position (getPosition().getX() + 7.5, getPosition().getY());
      if (direction == Position.DIRECTION_WEST)
        facing = new Position (getPosition().getX() - 7.5, getPosition().getY());
    }

    public Position directlyFacing()
    {
      return facing;
    }


    public void hurt()
    {
      if (this.isDead())
      {
        invincibility = 0;
        return;
      }

      if(invincibility <= 0)
      {
        if (Player.HURT_SOUND != null)
          Player.HURT_SOUND.play();
        health--;
        invincibility = Player.HURT_RECOVER;
      }
    }

    public boolean isDead()
    {
      return (health <= 0);
    }

    public void fullHeal()
    {
      invincibility = 0;
      getReadyToSmite();
      health = MAX_HEALTH;
    }

    private void flipFrame()
    {
      int frame = 0;
      frameCount.increment(Math.PI / 2);
      frame = direction + (int)Math.sin(frameCount.get()) + 1;
      currentSprite = sprites[frame];
    }

    private void handleDirctions (GUI tempGui)
    {
      boolean shouldFlip = smiting;
      double dx = 0;
      double dy = 0;

      if (tempGui.isWPressed())
      {
        dy = -yStep;
        direction = Position.DIRECTION_NORTH;
        shouldFlip = true;
      }

      if (tempGui.isAPressed())
      {
        dx = -xStep;
        direction = Position.DIRECTION_WEST;
        shouldFlip = true;
      }


      if (tempGui.isDPressed())
      {
        dx = xStep;
        direction = Position.DIRECTION_EAST;
        shouldFlip = true;
      }


      if (tempGui.isSPressed())
      {
        dy = yStep;
        direction = Position.DIRECTION_SOUTH;
        shouldFlip = true;
      }



      if (shouldFlip)
      {
        changePosition(new Position(getPosition().getX() + dx, getPosition().getY() + dy));
        flipFrame();
      }
      else
        {
          currentSprite = sprites[direction + 1];
        }

    }

    private void smite()
    {
      readyToSmite = false;
      smiting = true;
    }


    public void interact (Element e)
    {
      if (this.isDead())
        return;

      if (smiting  && e.isBad() && Position.distance(facing, e.getPosition()) < STRIKE_REACH + e.getGurth())
              e.delete();

    }



}