/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Definition;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPClass;
import marauroa.common.game.SyntaxException;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Serializable,
Iterable<String>,
Cloneable {
    private static Logger logger = Log4J.getLogger(Attributes.class);
    private boolean modified;
    private Map<String, String> content;
    private RPClass rpClass;
    Map<String, String> added;
    Map<String, String> deleted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fill(Attributes attributes) {
        this.setRPClass(attributes.rpClass);
        this.modified = attributes.modified;
        this.content.clear();
        Map<String, String> map = attributes.content;
        synchronized (map) {
            this.content.putAll(attributes.content);
        }
        this.added.clear();
        map = attributes.added;
        synchronized (map) {
            this.added.putAll(attributes.added);
        }
        this.deleted.clear();
        map = attributes.deleted;
        synchronized (map) {
            this.deleted.putAll(attributes.deleted);
        }
        return this;
    }

    public Attributes(RPClass rPClass) {
        this(rPClass, true);
    }

    Attributes(RPClass rPClass, boolean bl) {
        this.rpClass = rPClass;
        this.content = Collections.synchronizedMap(new HashMap());
        if (bl) {
            this.added = Collections.synchronizedMap(new HashMap());
            this.deleted = Collections.synchronizedMap(new HashMap());
        }
        this.modified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        Attributes attributes = (Attributes)super.clone();
        Map<String, String> map = this.content;
        synchronized (map) {
            attributes.content = Collections.synchronizedMap(new HashMap<String, String>(this.content));
        }
        map = this.added;
        synchronized (map) {
            attributes.added = Collections.synchronizedMap(new HashMap<String, String>(this.added));
        }
        map = this.deleted;
        synchronized (map) {
            attributes.deleted = Collections.synchronizedMap(new HashMap<String, String>(this.deleted));
        }
        return attributes;
    }

    public void setRPClass(RPClass rPClass) {
        this.rpClass = rPClass;
    }

    public void setRPClass(String string) {
        this.rpClass = RPClass.getRPClass(string);
        if (this.rpClass == null) {
            throw new SyntaxException("Missing RPClass: " + string);
        }
    }

    public RPClass getRPClass() {
        return this.rpClass;
    }

    public boolean instanceOf(RPClass rPClass) {
        return this.rpClass.subclassOf(rPClass.getName());
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    public boolean has(String string) {
        if (!this.content.containsKey(string)) {
            if (this.rpClass == null || string == null) {
                return false;
            }
            Definition definition = this.rpClass.getDefinition(Definition.DefinitionClass.STATIC, string);
            return definition != null && definition.getValue() != null;
        }
        return true;
    }

    public void put(String string, String string2) {
        this.validateValue(string, string2);
        this.added.put(string, string2);
        this.modified = true;
        if (string2 == null) {
            throw new IllegalArgumentException(string + " is null");
        }
        this.content.put(string, string2);
    }

    private void validateValue(String string, String string2) {
        Definition definition;
        if (this.rpClass != null && (definition = this.rpClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, string)) != null) {
            definition.validate(string2);
        }
    }

    public void add(String string, int n) {
        if (!this.has(string)) {
            this.put(string, n);
        } else {
            this.put(string, this.getInt(string) + n);
        }
    }

    public void put(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void put(String string, long l) {
        this.put(string, Long.toString(l));
    }

    public void put(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public void put(String string, List<String> list) {
        this.put(string, Attributes.listToString(list));
    }

    public String get(String string) {
        Definition definition;
        String string2 = this.content.get(string);
        if (string2 == null && string != null && (definition = this.rpClass.getDefinition(Definition.DefinitionClass.STATIC, string)) != null) {
            return definition.getValue();
        }
        return string2;
    }

    public int getInt(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attribute '" + string + "' not found");
        }
        return Integer.parseInt(string2);
    }

    public long getLong(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attribute '" + string + "' not found");
        }
        return Long.parseLong(string2);
    }

    public boolean getBool(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attribute '" + string + "' not found");
        }
        return Boolean.parseBoolean(string2);
    }

    public double getDouble(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("'" + string + "' not found");
        }
        return Double.parseDouble(string2);
    }

    public List<String> getList(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("'" + string + "' not found");
        }
        return Attributes.stringToList(string2);
    }

    public String remove(String string) {
        this.added.remove(string);
        this.deleted.put(string, "0");
        this.modified = true;
        return this.content.remove(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object != null && object instanceof Attributes && this.content.equals(((Attributes)object).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        return "Attributes of Class(" + this.rpClass.getName() + "): " + this.toAttributeString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toAttributeString() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = this.content;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.content.entrySet()) {
                stringBuilder.append("[" + entry.getKey());
                stringBuilder.append('=');
                Attributes.escapeAttributeString(stringBuilder, entry.getValue());
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    private static void escapeAttributeString(StringBuilder stringBuilder, String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\' && c != ']') continue;
            stringBuilder.append(string.substring(n, i));
            stringBuilder.append('\\');
            n = i;
        }
        stringBuilder.append(string.substring(n, string.length()));
    }

    private static String listToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\t");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static List<String> stringToList(String string) {
        String[] stringArray = string.substring(1, string.length() - 1).split("\t");
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedList.add(stringArray[i]);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> iterator() {
        HashSet<String> hashSet = null;
        Map<String, String> map = this.content;
        synchronized (map) {
            hashSet = new HashSet<String>(this.content.keySet());
        }
        return hashSet.iterator();
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        this.writeObject(outputSerializer, DetailLevel.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(OutputSerializer outputSerializer, DetailLevel detailLevel) throws IOException {
        int n = 0;
        Map<String, String> map = this.content;
        synchronized (map) {
            for (String object : this.content.keySet()) {
                try {
                    if (!this.shouldSerialize(Definition.DefinitionClass.ATTRIBUTE, object, detailLevel)) continue;
                    ++n;
                }
                catch (NullPointerException nullPointerException) {
                    logger.warn("Not found key: " + object, nullPointerException);
                    logger.warn(this);
                    throw nullPointerException;
                }
            }
        }
        outputSerializer.write(this.rpClass.getName());
        outputSerializer.write(n);
        map = this.content;
        synchronized (map) {
            for (Map.Entry entry : this.content.entrySet()) {
                boolean bl;
                String string = (String)entry.getKey();
                Definition definition = this.rpClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, string);
                if (definition.getType() == Definition.Type.LONG && outputSerializer.getProtocolVersion() < 35 || !this.shouldSerialize(definition, detailLevel)) continue;
                boolean bl2 = bl = detailLevel == DetailLevel.FULL || definition.getCode() == -1;
                if (bl) {
                    outputSerializer.write((short)-1);
                    outputSerializer.write(definition.getName());
                } else {
                    outputSerializer.write(definition.getCode());
                }
                definition.serialize((String)entry.getValue(), outputSerializer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToJson(StringBuilder stringBuilder, DetailLevel detailLevel) {
        OutputSerializer.writeJson(stringBuilder, "c", this.rpClass.getName());
        stringBuilder.append(",\"a\":{");
        Map<String, String> map = this.content;
        synchronized (map) {
            boolean bl = true;
            for (Map.Entry<String, String> entry : this.content.entrySet()) {
                String string = entry.getKey();
                Definition definition = this.rpClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, string);
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                OutputSerializer.writeJson(stringBuilder, string, entry.getValue());
            }
        }
        stringBuilder.append("}");
    }

    boolean shouldSerialize(Definition.DefinitionClass definitionClass, String string, DetailLevel detailLevel) {
        Definition definition = this.rpClass.getDefinition(definitionClass, string);
        if (definition == null) {
            logger.error("No definition " + (Object)((Object)definitionClass) + " named " + string + " for class " + this.rpClass, new Throwable());
            return false;
        }
        return this.shouldSerialize(definition, detailLevel);
    }

    boolean shouldSerialize(Definition definition, DetailLevel detailLevel) {
        if (detailLevel == DetailLevel.FULL && !definition.isStorable()) {
            return false;
        }
        return detailLevel == DetailLevel.PRIVATE && !definition.isHidden() || definition.isVisible() || detailLevel == DetailLevel.FULL;
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        this.modified = true;
        this.rpClass = RPClass.getRPClass(inputSerializer.readString());
        int n = inputSerializer.readInt();
        if (n > 262144) {
            throw new IOException("Illegal request of an list of " + String.valueOf(n) + " size");
        }
        this.content.clear();
        for (int i = 0; i < n; ++i) {
            short s = inputSerializer.readShort();
            String string = s == -1 ? inputSerializer.readString() : this.rpClass.getName(Definition.DefinitionClass.ATTRIBUTE, s);
            Definition definition = this.rpClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, string);
            if (definition == null) {
                throw new IOException("RPClass(" + this.rpClass + ") definition for attribute not found: " + string);
            }
            String string2 = definition.deserialize(inputSerializer);
            this.content.put(string, string2);
        }
    }

    public void readFromMap(Map<String, Object> map) throws IOException {
        this.modified = true;
        String string = (String)map.get("_rpclass");
        if (string == null) {
            string = "";
        }
        this.rpClass = RPClass.getRPClass(string);
        this.content.clear();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string2.startsWith("_")) continue;
            Definition definition = this.rpClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, string2);
            if (definition != null) {
                if (!(entry.getValue() instanceof String)) continue;
                this.content.put(string2, (String)entry.getValue());
                continue;
            }
            throw new IOException("RPClass(" + this.rpClass + ") definition for attribute not found: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVisible(boolean bl) {
        Map<String, String> map = this.content;
        synchronized (map) {
            Iterator<Map.Entry<String, String>> iterator = this.content.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                Definition definition = this.rpClass.getDefinition(Definition.DefinitionClass.ATTRIBUTE, entry.getKey());
                if (definition == null) {
                    logger.warn("Null Definition for attribute: " + entry.getKey() + " of RPClass: " + this.rpClass.getName());
                    continue;
                }
                if (!definition.isVisible() || entry.getKey().equals("id")) continue;
                iterator.remove();
                this.modified = true;
                this.deleted.remove(entry.getKey());
                this.added.remove(entry.getKey());
            }
        }
    }

    public void resetAddedAndDeletedAttributes() {
        if (this.modified) {
            this.added.clear();
            this.deleted.clear();
            this.modified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddedAttributes(Attributes attributes) {
        this.rpClass = attributes.rpClass;
        boolean bl = false;
        Object object = attributes.added;
        synchronized (object) {
            for (Map.Entry<String, String> entry : attributes.added.entrySet()) {
                bl = true;
                this.content.put(entry.getKey(), entry.getValue());
            }
        }
        if (bl) {
            this.content.put("id", attributes.get("id"));
            object = attributes.get("zoneid");
            if (object != null) {
                this.content.put("zoneid", (String)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeletedAttributes(Attributes attributes) {
        this.rpClass = attributes.rpClass;
        boolean bl = false;
        Object object = attributes.deleted;
        synchronized (object) {
            for (Map.Entry<String, String> entry : attributes.deleted.entrySet()) {
                bl = true;
                this.content.put(entry.getKey(), entry.getValue());
            }
        }
        if (bl) {
            this.content.put("id", attributes.get("id"));
            object = attributes.get("zoneid");
            if (object != null) {
                this.content.put("zoneid", (String)object);
            }
        }
    }

    public void applyDifferences(Attributes attributes, Attributes attributes2) {
        if (attributes2 != null) {
            for (String string : attributes2) {
                if (string.equals("id") || string.equals("zoneid")) continue;
                this.remove(string);
            }
        }
        if (attributes != null) {
            for (String string : attributes) {
                this.put(string, attributes.get(string));
            }
        }
    }
}

