/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.game.IRPZone;
import marauroa.common.game.RPObject;

public class Perception {
    public static final byte DELTA = 0;
    public static final byte SYNC = 1;
    public byte type;
    public IRPZone.ID zoneid;
    public List<RPObject> addedList;
    public List<RPObject> modifiedAddedList;
    public List<RPObject> modifiedDeletedList;
    public List<RPObject> deletedList;

    public Perception(byte by, IRPZone.ID iD) {
        this.type = by;
        this.zoneid = iD;
        this.addedList = new LinkedList<RPObject>();
        this.modifiedAddedList = new LinkedList<RPObject>();
        this.modifiedDeletedList = new LinkedList<RPObject>();
        this.deletedList = new LinkedList<RPObject>();
    }

    public void added(RPObject rPObject) {
        if (!this.addedHas(rPObject)) {
            this.addedList.add(rPObject);
        }
    }

    public void modified(RPObject rPObject) throws Exception {
        if (!this.removedHas(rPObject) && !this.addedHas(rPObject)) {
            RPObject rPObject2 = new RPObject();
            RPObject rPObject3 = new RPObject();
            rPObject.getDifferences(rPObject2, rPObject3);
            if (rPObject2.size() > 0) {
                this.modifiedAddedList.add(rPObject2);
            }
            if (rPObject3.size() > 0) {
                this.modifiedDeletedList.add(rPObject3);
            }
        } else {
            rPObject.resetAddedAndDeleted();
        }
    }

    public void removed(RPObject rPObject) {
        if (this.addedHas(rPObject)) {
            Iterator<RPObject> iterator = this.addedList.iterator();
            while (iterator.hasNext()) {
                RPObject rPObject2 = iterator.next();
                if (!rPObject2.get("id").equals(rPObject.get("id"))) continue;
                iterator.remove();
                return;
            }
        }
        if (!this.removedHas(rPObject)) {
            this.deletedList.add(rPObject);
        }
    }

    public int size() {
        return this.addedList.size() + this.modifiedAddedList.size() + this.modifiedDeletedList.size() + this.deletedList.size();
    }

    public void clear() {
        for (RPObject rPObject : this.addedList) {
            rPObject.clearEvents();
        }
        this.addedList.clear();
        this.modifiedAddedList.clear();
        this.modifiedDeletedList.clear();
        this.deletedList.clear();
    }

    private boolean removedHas(RPObject rPObject) {
        for (RPObject rPObject2 : this.deletedList) {
            if (!rPObject2.get("id").equals(rPObject.get("id"))) continue;
            return true;
        }
        return false;
    }

    private boolean addedHas(RPObject rPObject) {
        for (RPObject rPObject2 : this.addedList) {
            if (!rPObject2.get("id").equals(rPObject.get("id"))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#Added: \n");
        for (RPObject rPObject : this.addedList) {
            stringBuilder.append(rPObject);
            stringBuilder.append("\n");
        }
        stringBuilder.append("#Modified added: \n");
        for (RPObject rPObject : this.modifiedAddedList) {
            stringBuilder.append(rPObject);
            stringBuilder.append("\n");
        }
        stringBuilder.append("#Modifed deleted: \n");
        for (RPObject rPObject : this.modifiedDeletedList) {
            stringBuilder.append(rPObject);
            stringBuilder.append("\n");
        }
        stringBuilder.append("#Deleted: \n");
        for (RPObject rPObject : this.deletedList) {
            stringBuilder.append(rPObject);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

