/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.MessageFactory;
import marauroa.common.net.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decoder {
    private static final Logger logger = Log4J.getLogger(Decoder.class);
    private Map<Object, MessageParts> content = new HashMap<Object, MessageParts>();
    MessageFactory msgFactory = MessageFactory.getFactory();
    private static Decoder instance;

    public static Decoder get() {
        if (instance == null) {
            instance = new Decoder();
        }
        return instance;
    }

    private Decoder() {
    }

    public void clear(SocketChannel socketChannel) {
        this.content.remove(socketChannel);
    }

    static int getSizeOfMessage(byte[] byArray) {
        return (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
    }

    public List<Message> decode(Object object, byte[] byArray) throws IOException, InvalidVersionException {
        MessageParts messageParts = this.content.get(object);
        if (messageParts == null) {
            if (byArray.length < 4) {
                throw new IOException("Message is too short. Missing mandatory fields.");
            }
            int n = Decoder.getSizeOfMessage(byArray);
            if (n < 0) {
                throw new IOException("Message size is negative. Message ignored.");
            }
            if (byArray.length == n) {
                Message message = this.msgFactory.getMessage(byArray, 4);
                LinkedList<Message> linkedList = new LinkedList<Message>();
                linkedList.add(message);
                return linkedList;
            }
            logger.debug("Message full body missing (" + n + "), waiting for more data (" + byArray.length + ").");
            messageParts = new MessageParts();
            this.content.put(object, messageParts);
        } else {
            logger.debug("Existing data, trying to complete Message full body");
        }
        messageParts.add(byArray);
        LinkedList<Message> linkedList = new LinkedList<Message>();
        while (!messageParts.isEmpty()) {
            Message message = messageParts.build();
            if (message != null) {
                linkedList.add(message);
                continue;
            }
            if (linkedList.isEmpty()) {
                return null;
            }
            return linkedList;
        }
        this.content.remove(object);
        return linkedList;
    }

    class MessageParts {
        public Vector<byte[]> parts = new Vector();

        public void add(byte[] byArray) {
            this.parts.add(byArray);
        }

        public boolean isEmpty() {
            return this.parts.isEmpty();
        }

        public Message build() throws IOException, InvalidVersionException {
            Object object;
            byte[] byArray2;
            int n = 0;
            for (byte[] byArray2 : this.parts) {
                n += byArray2.length;
            }
            if (n < 4) {
                return null;
            }
            int n2 = this.readSizeOfMessage();
            if (n < n2) {
                return null;
            }
            byArray2 = new byte[n2];
            int n3 = n2;
            int n4 = 0;
            Iterator<byte[]> iterator = this.parts.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (n3 - ((byte[])object).length < 0) {
                    System.arraycopy(object, 0, byArray2, n4, n3);
                    byte[] byArray3 = new byte[((byte[])object).length - n3];
                    System.arraycopy(object, n3, byArray3, 0, ((byte[])object).length - n3);
                    this.parts.set(0, byArray3);
                    break;
                }
                System.arraycopy(object, 0, byArray2, n4, ((byte[])object).length);
                n4 += ((byte[])object).length;
                n3 -= ((byte[])object).length;
                iterator.remove();
            }
            object = Decoder.this.msgFactory.getMessage(byArray2, 4);
            return object;
        }

        private int readSizeOfMessage() {
            byte[] byArray = new byte[4];
            int n = 0;
            block0: for (byte[] byArray2 : this.parts) {
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[n] = byArray2[i];
                    if (n == 3) break block0;
                    ++n;
                }
            }
            return Decoder.getSizeOfMessage(byArray);
        }
    }
}

