/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageC2SCreateAccount
extends Message {
    private String username;
    private String password;
    private String email;
    private String language = Locale.ENGLISH.getLanguage();

    public MessageC2SCreateAccount() {
        super(Message.MessageType.C2S_CREATEACCOUNT, null);
    }

    public MessageC2SCreateAccount(Channel channel, String string, String string2, String string3, String string4) {
        super(Message.MessageType.C2S_CREATEACCOUNT, channel);
        this.username = string;
        this.password = string2;
        this.email = string3;
        this.language = string4;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public String toString() {
        return "Message (C2S CreateAccount) from (" + this.getAddress() + ") CONTENTS: (" + this.username + ";" + this.password + ";" + this.email + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.username);
        outputSerializer.write(this.password);
        outputSerializer.write(this.email);
        outputSerializer.write255LongString(this.language);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.username = inputSerializer.readString();
        this.password = inputSerializer.readString();
        this.email = inputSerializer.readString();
        if (inputSerializer.available() > 0) {
            this.language = inputSerializer.read255LongString();
        }
        if (this.type != Message.MessageType.C2S_CREATEACCOUNT) {
            throw new IOException();
        }
    }

    @Override
    public void readFromMap(Map<String, Object> map) throws IOException {
        super.readFromMap(map);
        if (map.get("u") != null) {
            this.username = map.get("u").toString();
        }
        if (map.get("p") != null) {
            this.password = map.get("p").toString();
        }
        if (map.get("e") != null) {
            this.email = map.get("e").toString();
        }
        if (map.get("l") != null) {
            this.language = map.get("l").toString();
        }
        if (this.type != Message.MessageType.C2S_CREATEACCOUNT) {
            throw new IOException();
        }
    }
}

