/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Result;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageS2CCreateAccountNACK;

public class MessageS2CCreateCharacterNACK
extends Message {
    private static Logger logger = Log4J.getLogger(MessageS2CCreateAccountNACK.class);
    private String character;
    private Result reason;

    public MessageS2CCreateCharacterNACK() {
        super(Message.MessageType.S2C_CREATECHARACTER_NACK, null);
    }

    public MessageS2CCreateCharacterNACK(Channel channel, String string, Result result) {
        super(Message.MessageType.S2C_CREATECHARACTER_NACK, channel);
        this.character = string;
        this.reason = result;
    }

    public Result getResolutionCode() {
        return this.reason;
    }

    public String getResolution() {
        return this.reason.getText();
    }

    public String toString() {
        return "Message (S2C Create Character NACK) from (" + this.getAddress() + ") CONTENTS: (" + this.getResolution() + ")";
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write((byte)this.reason.ordinal());
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        try {
            this.reason = Result.values()[inputSerializer.readByte()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error(arrayIndexOutOfBoundsException, arrayIndexOutOfBoundsException);
            this.reason = Result.FAILED_EXCEPTION;
        }
        if (this.type != Message.MessageType.S2C_CREATECHARACTER_NACK) {
            throw new IOException();
        }
    }

    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",");
        OutputSerializer.writeJson(stringBuilder, "charname", this.character);
        stringBuilder.append(",\"reason\": {");
        OutputSerializer.writeJson(stringBuilder, "code", Integer.toString(this.reason.ordinal()));
        stringBuilder.append(",");
        OutputSerializer.writeJson(stringBuilder, "name", this.reason.name());
        stringBuilder.append(",");
        OutputSerializer.writeJson(stringBuilder, "text", this.reason.getText());
        stringBuilder.append("}");
    }
}

