/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import marauroa.common.Utility;
import marauroa.common.game.RPClass;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CServerInfo
extends Message {
    private String[] contents;

    public MessageS2CServerInfo() {
        super(Message.MessageType.S2C_SERVERINFO, null);
    }

    public MessageS2CServerInfo(Channel channel, String[] stringArray) {
        super(Message.MessageType.S2C_SERVERINFO, channel);
        this.contents = Utility.copy(stringArray);
    }

    public String[] getContents() {
        return Utility.copy(this.contents);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(" ");
        for (int i = 0; i < this.contents.length; ++i) {
            stringBuilder.append("[" + this.contents[i] + "],");
        }
        return "Message (S2C Server Info) from (" + this.getAddress() + ") CONTENTS: (" + stringBuilder.substring(0, stringBuilder.length() - 1) + ")";
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        RPClass rPClass;
        super.writeObject(outputSerializer);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        OutputSerializer outputSerializer2 = new OutputSerializer(deflaterOutputStream);
        outputSerializer2.setProtocolVersion(outputSerializer.getProtocolVersion());
        outputSerializer2.write(this.contents);
        int n = RPClass.size();
        Iterator<RPClass> iterator = RPClass.iterator();
        while (iterator.hasNext()) {
            rPClass = iterator.next();
            if (!"".equals(rPClass.getName())) continue;
            --n;
            break;
        }
        outputSerializer2.write(n);
        iterator = RPClass.iterator();
        while (iterator.hasNext()) {
            rPClass = iterator.next();
            if ("".equals(rPClass.getName())) continue;
            outputSerializer2.write(rPClass);
        }
        deflaterOutputStream.close();
        outputSerializer.write(byteArrayOutputStream.toByteArray());
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputSerializer.readByteArray());
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        InputSerializer inputSerializer2 = new InputSerializer(inflaterInputStream);
        inputSerializer2.setProtocolVersion(this.protocolVersion);
        this.contents = inputSerializer2.readStringArray();
        int n = inputSerializer2.readInt();
        for (int i = 0; i < n; ++i) {
            inputSerializer2.readObject(new RPClass());
        }
        if (this.type != Message.MessageType.S2C_SERVERINFO) {
            throw new IOException();
        }
    }

    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"contents\":[");
        boolean bl = true;
        for (String string : this.contents) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            OutputSerializer.writeJson(stringBuilder, string);
        }
        stringBuilder.append("]");
    }
}

