/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.IRPZone;
import marauroa.common.game.RPObject;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.StringChecker;
import marauroa.server.db.TransactionPool;
import marauroa.server.game.rp.RPObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPZoneDAO {
    private static final Logger logger = Log4J.getLogger(RPZoneDAO.class);
    protected RPObjectFactory factory;

    protected RPZoneDAO(RPObjectFactory rPObjectFactory) {
        this.factory = rPObjectFactory;
    }

    public void loadRPZone(DBTransaction dBTransaction, IRPZone iRPZone) throws SQLException, IOException {
        String string = iRPZone.getID().getID();
        String string2 = "select data, protocol_version from rpzone where zone_id='[zoneid]'";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zoneid", string);
        logger.debug("loadRPZone is executing query " + string2);
        ResultSet resultSet = dBTransaction.query(string2, hashMap);
        if (resultSet.next()) {
            byte[] byArray = resultSet.getBytes("data");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while ((n = byteArrayInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            ((InputStream)byteArrayInputStream).close();
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray3);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream2, new Inflater());
            InputSerializer inputSerializer = new InputSerializer(inflaterInputStream);
            int n2 = 32;
            Object object = resultSet.getObject("protocol_version");
            if (object != null) {
                n2 = (Integer)object;
            }
            inputSerializer.setProtocolVersion(n2);
            int n3 = inputSerializer.readInt();
            for (int i = 0; i < n3; ++i) {
                try {
                    RPObject rPObject = this.factory.transform((RPObject)inputSerializer.readObject(new RPObject()));
                    if (rPObject == null) continue;
                    iRPZone.assignRPObjectID(rPObject);
                    iRPZone.add(rPObject);
                    continue;
                }
                catch (Exception exception) {
                    logger.error("Problem loading RPZone: ", exception);
                }
            }
        }
        resultSet.close();
    }

    public void storeRPZone(DBTransaction dBTransaction, IRPZone iRPZone) throws IOException, SQLException {
        this.storeRPZone(dBTransaction, iRPZone, iRPZone);
    }

    /*
     * WARNING - void declaration
     */
    public void storeRPZone(DBTransaction dBTransaction, IRPZone iRPZone, Iterable<RPObject> iterable) throws IOException, SQLException {
        void var11_17;
        String string = iRPZone.getID().getID();
        if (!StringChecker.validString(string)) {
            throw new SQLException("Invalid string zoneid=(" + string + ")");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        OutputSerializer outputSerializer = new OutputSerializer(deflaterOutputStream);
        int n = 0;
        for (RPObject object22 : iterable) {
            if (!object22.isStorable()) continue;
            ++n;
        }
        outputSerializer.write(n);
        boolean bl = true;
        for (RPObject rPObject : iterable) {
            if (!rPObject.isStorable()) continue;
            rPObject.writeObject(outputSerializer, DetailLevel.FULL);
            bl = false;
        }
        deflaterOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        if (this.hasRPZone(dBTransaction, iRPZone.getID())) {
            String string2 = "update rpzone set data=?, protocol_version=[protocolVersion] where zone_id='[zoneid]'";
        } else {
            if (bl) {
                return;
            }
            String string3 = "insert into rpzone(zone_id, data, protocol_version) values('[zoneid]', ?, [protocolVersion])";
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zoneid", string);
        hashMap.put("protocolVersion", outputSerializer.getProtocolVersion());
        logger.debug("storeRPZone is executing query " + (String)var11_17);
        dBTransaction.execute((String)var11_17, hashMap, byteArrayInputStream);
    }

    public boolean hasRPZone(DBTransaction dBTransaction, IRPZone.ID iD) throws SQLException {
        String string = "SELECT count(*) as amount FROM rpzone where zone_id='[zoneid]'";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zoneid", iD.getID());
        int n = dBTransaction.querySingleCellInt(string, hashMap);
        return n > 0;
    }

    public void loadRPZone(IRPZone iRPZone) throws SQLException, IOException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.loadRPZone(dBTransaction, iRPZone);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    public void storeRPZone(IRPZone iRPZone) throws IOException, SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            this.storeRPZone(dBTransaction, iRPZone);
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRPZone(IRPZone.ID iD) throws SQLException {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            boolean bl;
            boolean bl2 = bl = this.hasRPZone(dBTransaction, iD);
            return bl2;
        }
        finally {
            TransactionPool.get().commit(dBTransaction);
        }
    }
}

