/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.dbcommand;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.server.db.DBTransaction;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.dbcommand.DBCommandWithCallback;
import marauroa.server.game.messagehandler.DelayedEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadAllCharactersCommand
extends DBCommandWithCallback {
    private String username;
    private Map<String, RPObject> characters;

    public LoadAllCharactersCommand(String string) {
        this.username = string;
    }

    public LoadAllCharactersCommand(String string, DelayedEventHandler delayedEventHandler, int n, Channel channel, int n2) {
        super(delayedEventHandler, n, channel, n2);
        this.username = string;
    }

    @Override
    public void execute(DBTransaction dBTransaction) throws SQLException, IOException {
        this.characters = DAORegister.get().get(CharacterDAO.class).loadAllCharacters(dBTransaction, this.username);
    }

    public Map<String, RPObject> getCharacters() {
        return this.characters;
    }

    public String toString() {
        return "LoadAllCharactersCommand [username=" + this.username + ", characters=" + this.characters + "]";
    }
}

