/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.dbcommand;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.net.Channel;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.server.db.DBTransaction;
import marauroa.server.game.container.SecuredLoginInfo;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.DAORegister;
import marauroa.server.game.db.LoginEventDAO;
import marauroa.server.game.dbcommand.DBCommandWithCallback;
import marauroa.server.game.messagehandler.DelayedEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginCommand
extends DBCommandWithCallback {
    private SecuredLoginInfo info;
    private MessageS2CLoginNACK.Reasons failReason = null;
    private String failMessage = null;
    private List<String> previousLogins;

    public LoginCommand(SecuredLoginInfo securedLoginInfo) {
        this.info = securedLoginInfo;
    }

    public LoginCommand(SecuredLoginInfo securedLoginInfo, DelayedEventHandler delayedEventHandler, int n, Channel channel, int n2) {
        super(delayedEventHandler, n, channel, n2);
        this.info = securedLoginInfo;
    }

    @Override
    public void execute(DBTransaction dBTransaction) throws SQLException, IOException {
        if (this.info.isBlocked(dBTransaction)) {
            this.failReason = MessageS2CLoginNACK.Reasons.TOO_MANY_TRIES;
            this.info.addLoginEvent(dBTransaction, this.info.address, 4);
            return;
        }
        if (!this.info.verify(dBTransaction)) {
            if (this.info.reason == null) {
                this.info.reason = MessageS2CLoginNACK.Reasons.USERNAME_WRONG;
            }
            this.failReason = this.info.reason;
            this.info.addLoginEvent(dBTransaction, this.info.address, 0);
            return;
        }
        String string = DAORegister.get().get(AccountDAO.class).getAccountBanMessage(dBTransaction, this.info.username);
        if (string != null) {
            String string2 = DAORegister.get().get(AccountDAO.class).getAccountStatus(dBTransaction, this.info.username);
            if (string2 != null) {
                if (string2.equals("banned")) {
                    this.info.addLoginEvent(dBTransaction, this.info.address, 2);
                } else if (string2.equals("inactive")) {
                    this.info.addLoginEvent(dBTransaction, this.info.address, 3);
                } else if (string2.equals("merged")) {
                    this.info.addLoginEvent(dBTransaction, this.info.address, 5);
                }
            }
            this.failMessage = string;
            return;
        }
        this.previousLogins = DAORegister.get().get(LoginEventDAO.class).getLoginEvents(dBTransaction, this.info.username, 1);
        this.info.addLoginEvent(dBTransaction, this.info.address, 1);
    }

    public SecuredLoginInfo getInfo() {
        return this.info;
    }

    public MessageS2CLoginNACK.Reasons getFailReason() {
        return this.failReason;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public List<String> getPreviousLogins() {
        return new LinkedList<String>(this.previousLogins);
    }

    public String toString() {
        return "LoginCommand [info=" + this.info + ", failReason=" + (Object)((Object)this.failReason) + ", failMessage=" + this.failMessage + ", previousLogins=" + this.previousLogins + "]";
    }
}

