/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SAction;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.messagehandler.MessageHandler;

class ActionHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(ActionHandler.class);

    ActionHandler() {
    }

    public void process(Message message) {
        try {
            MessageC2SAction messageC2SAction = (MessageC2SAction)message;
            int n = messageC2SAction.getClientID();
            PlayerEntry playerEntry = this.playerContainer.get(n);
            if (!this.isValidEvent(messageC2SAction, playerEntry, ClientState.GAME_BEGIN)) {
                return;
            }
            playerEntry.update();
            RPAction rPAction = messageC2SAction.getRPAction();
            RPObject rPObject = playerEntry.object;
            rPAction.put("sourceid", rPObject.get("id"));
            rPAction.put("zoneid", rPObject.get("zoneid"));
            this.stats.add("Actions added", 1);
            String string = rPAction.get("type");
            if (string != null) {
                this.stats.add("Actions " + string, 1);
            } else {
                this.stats.add("Actions invalid", 1);
            }
            this.rpMan.addRPAction(rPObject, rPAction);
        }
        catch (Exception exception) {
            this.stats.add("Actions invalid", 1);
            logger.error("error while processing ActionEvent", exception);
        }
    }
}

