/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SKeepAlive;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.messagehandler.MessageHandler;

class KeepAliveHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(KeepAliveHandler.class);

    KeepAliveHandler() {
    }

    public void process(Message message) {
        MessageC2SKeepAlive messageC2SKeepAlive = (MessageC2SKeepAlive)message;
        try {
            int n = messageC2SKeepAlive.getClientID();
            PlayerEntry playerEntry = this.playerContainer.get(n);
            if (!this.isValidEvent(messageC2SKeepAlive, playerEntry, ClientState.GAME_BEGIN, ClientState.LOGIN_COMPLETE)) {
                return;
            }
            playerEntry.update();
        }
        catch (Exception exception) {
            logger.error("error while processing Keep Alive event", exception);
        }
    }
}

