/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import java.io.IOException;
import java.util.Locale;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.Hash;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SLoginSendPromise;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.common.net.message.MessageS2CLoginSendNonce;
import marauroa.common.net.message.MessageSendByteArray;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.SecuredLoginInfo;
import marauroa.server.game.messagehandler.MessageHandler;

class LoginSendPromiseHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(LoginSendPromiseHandler.class);
    private int maxNumberOfPlayers = 128;

    public LoginSendPromiseHandler() {
        try {
            String string = Configuration.getConfiguration().get("max_number_of_players");
            if (string != null) {
                this.maxNumberOfPlayers = Integer.parseInt(string.trim());
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
    }

    public void process(Message message) {
        try {
            Object object;
            if (this.playerContainer.size() >= this.maxNumberOfPlayers) {
                logger.info("Server is full, making room now");
                object = this.playerContainer.getIdleEntry();
                if (object != null) {
                    this.netMan.disconnectClient(((PlayerEntry)object).channel);
                    this.playerContainer.remove(((PlayerEntry)object).clientid);
                }
            }
            if (this.playerContainer.size() >= this.maxNumberOfPlayers) {
                logger.warn("Server is full, Client(" + message.getAddress().toString() + ") can't login. You may want to increase max_number_of_players in your server.init. Current value is: " + this.maxNumberOfPlayers);
                object = new MessageS2CLoginNACK(message.getChannel(), MessageS2CLoginNACK.Reasons.SERVER_IS_FULL);
                ((Message)object).setProtocolVersion(message.getProtocolVersion());
                this.netMan.sendMessage((Message)object);
                return;
            }
            object = (MessageC2SLoginSendPromise)message;
            PlayerEntry playerEntry = this.playerContainer.add(((Message)object).getChannel());
            playerEntry.setProtocolVersion(message.getProtocolVersion());
            playerEntry.locale = new Locale(((MessageC2SLoginSendPromise)object).getLanguage());
            byte[] byArray = Hash.random(Hash.hashLength());
            byte[] byArray2 = ((MessageSendByteArray)object).getHash();
            playerEntry.loginInformations = new SecuredLoginInfo(this.key, byArray2, byArray, ((Message)object).getAddress());
            MessageS2CLoginSendNonce messageS2CLoginSendNonce = new MessageS2CLoginSendNonce(message.getChannel(), byArray);
            messageS2CLoginSendNonce.setClientID(playerEntry.clientid);
            messageS2CLoginSendNonce.setProtocolVersion(message.getProtocolVersion());
            this.netMan.sendMessage(messageS2CLoginSendNonce);
        }
        catch (Exception exception) {
            logger.error("client not found", exception);
        }
    }
}

