/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2STransferACK;
import marauroa.common.net.message.MessageS2CTransfer;
import marauroa.common.net.message.TransferContent;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.messagehandler.MessageHandler;

class TransferACKHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(TransferACKHandler.class);

    TransferACKHandler() {
    }

    public void process(Message message) {
        MessageC2STransferACK messageC2STransferACK = (MessageC2STransferACK)message;
        try {
            int n = messageC2STransferACK.getClientID();
            PlayerEntry playerEntry = this.playerContainer.get(n);
            if (!this.isValidEvent(messageC2STransferACK, playerEntry, ClientState.GAME_BEGIN)) {
                return;
            }
            MessageS2CTransfer messageS2CTransfer = new MessageS2CTransfer(playerEntry.channel);
            messageS2CTransfer.setClientID(n);
            messageS2CTransfer.setProtocolVersion(messageC2STransferACK.getProtocolVersion());
            for (TransferContent transferContent : messageC2STransferACK.getContents()) {
                TransferContent transferContent2 = playerEntry.getContent(transferContent.name);
                if (transferContent.ack) {
                    logger.debug("Trying transfer content " + transferContent);
                    if (transferContent2 != null) {
                        this.stats.add("Transfer content", 1);
                        this.stats.add("Tranfer content size", transferContent2.data.length);
                        logger.debug("Transfering content " + transferContent2);
                        messageS2CTransfer.addContent(transferContent2);
                    } else {
                        logger.warn("Cannot transfer content (" + transferContent.name + ") because it is null");
                    }
                } else {
                    this.stats.add("Transfer content cache", 1);
                }
                if (transferContent2 == null) continue;
                playerEntry.removeContent(transferContent2);
            }
            if (!messageS2CTransfer.isEmpty()) {
                this.netMan.sendMessage(messageS2CTransfer);
            }
        }
        catch (Exception exception) {
            logger.error("error while processing TransferACK", exception);
        }
    }
}

