/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.python;

import marauroa.common.Configuration;
import marauroa.server.game.python.PythonRP;
import marauroa.server.game.python.PythonWorld;
import marauroa.server.game.rp.RPWorld;
import org.python.core.PyInstance;
import org.python.util.PythonInterpreter;

class GameScript {
    private PythonInterpreter interpreter;
    private Configuration conf = Configuration.getConfiguration();
    private static GameScript gameScript = null;

    private GameScript() throws Exception {
        this.interpreter = new PythonInterpreter();
        this.interpreter.execfile(this.conf.get("python_script"));
    }

    public static GameScript getGameScript() throws Exception {
        if (gameScript == null) {
            gameScript = new GameScript();
        }
        return gameScript;
    }

    public void setRPWorld(RPWorld rPWorld) {
        this.interpreter.set("gamescript__world", (Object)rPWorld);
    }

    public PythonWorld getWorld() throws Exception {
        String string = this.conf.get("python_script_world");
        PyInstance pyInstance = (PyInstance)this.interpreter.eval(string + "()");
        return (PythonWorld)pyInstance.__tojava__(PythonWorld.class);
    }

    public PythonRP getGameRules() throws Exception {
        String string = this.conf.get("python_script_ruleprocessor");
        PyInstance pyInstance = (PyInstance)this.interpreter.eval(string + "(gamescript__world)");
        return (PythonRP)pyInstance.__tojava__(PythonRP.class);
    }
}

