/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.rp;

import java.lang.reflect.Method;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.server.game.db.DatabaseFactory;
import marauroa.server.game.rp.NoFactoryConfException;

public class RPObjectFactory {
    private static final Logger logger = Log4J.getLogger(DatabaseFactory.class);
    private static RPObjectFactory singleton;

    public static RPObjectFactory get() throws NoFactoryConfException {
        try {
            Configuration configuration = Configuration.getConfiguration();
            String string = configuration.get("factory_implementation");
            if (string == null) {
                string = RPObjectFactory.class.getName();
            }
            return RPObjectFactory.get(string);
        }
        catch (Exception exception) {
            logger.error("Can't create factory", exception);
            throw new NoFactoryConfException(exception);
        }
    }

    public static RPObjectFactory get(String string) throws NoFactoryConfException {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getDeclaredMethod("getFactory", new Class[0]);
            return (RPObjectFactory)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            logger.error("Can't create factory(" + string + ")", exception);
            throw new NoFactoryConfException(exception);
        }
    }

    public static RPObjectFactory getFactory() {
        if (singleton == null) {
            singleton = new RPObjectFactory();
        }
        return singleton;
    }

    public RPObject transform(RPObject rPObject) {
        return rPObject;
    }
}

