/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.rp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.server.game.rp.DebugInterface;
import marauroa.server.game.rp.IRPRuleProcessor;
import org.apache.log4j.MDC;

public class RPScheduler {
    private static final Logger logger = Log4J.getLogger(RPScheduler.class);
    private Map<RPObject, List<RPAction>> actualTurn = new HashMap<RPObject, List<RPAction>>();
    private Map<RPObject, List<RPAction>> nextTurn = new HashMap<RPObject, List<RPAction>>();

    public synchronized boolean addRPAction(RPObject rPObject, RPAction rPAction, IRPRuleProcessor iRPRuleProcessor) {
        try {
            List<RPAction> list = this.nextTurn.get(rPObject);
            if (list == null) {
                list = new LinkedList<RPAction>();
                this.nextTurn.put(rPObject, list);
            }
            if (iRPRuleProcessor.onActionAdd(rPObject, rPAction, list)) {
                list.add(rPAction);
            }
            return true;
        }
        catch (Exception exception) {
            logger.error("cannot add action to RPScheduler, Action(" + rPAction + ") is missing a required attributes", exception);
            return false;
        }
    }

    public synchronized void clearRPActions(RPObject rPObject) {
        this.nextTurn.remove(rPObject);
        this.actualTurn.remove(rPObject);
    }

    public synchronized void visit(IRPRuleProcessor iRPRuleProcessor) {
        for (Map.Entry<RPObject, List<RPAction>> entry : this.actualTurn.entrySet()) {
            RPObject rPObject = entry.getKey();
            List<RPAction> list = entry.getValue();
            for (RPAction rPAction : list) {
                MDC.put((String)"context", (Object)(rPObject + " " + rPAction));
                try {
                    if (DebugInterface.get().executeAction(rPObject, rPAction)) {
                        iRPRuleProcessor.execute(rPObject, rPAction);
                    }
                }
                catch (Exception exception) {
                    logger.error("error in visit()", exception);
                }
                MDC.remove((String)"context");
            }
        }
    }

    public synchronized void nextTurn() {
        Map<RPObject, List<RPAction>> map = this.actualTurn;
        this.actualTurn = this.nextTurn;
        this.nextTurn = map;
        this.nextTurn.clear();
    }
}

