/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Item;
import games.stendhal.client.entity.Player;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.j2d.entity.EntityViewFactory;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

class EntityViewManager {
    private static final Logger logger = Logger.getLogger(EntityViewManager.class);
    private static final EntityViewComparator entityViewComparator = new EntityViewComparator();
    private final List<EntityView<IEntity>> views = new ArrayList<EntityView<IEntity>>();
    private final List<EntityView<IEntity>> visibleViews = new ArrayList<EntityView<IEntity>>();
    private final Map<IEntity, EntityView<IEntity>> entities = new HashMap<IEntity, EntityView<IEntity>>();
    private final String userName = StendhalClient.get().getCharacter();

    EntityViewManager() {
    }

    EntityView<IEntity> addEntity(IEntity iEntity) {
        EntityView<IEntity> entityView = EntityViewFactory.create(iEntity);
        if (entityView != null) {
            this.entities.put(iEntity, entityView);
            this.addEntityView(entityView);
        }
        return entityView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntityView(EntityView<IEntity> entityView) {
        List<EntityView<IEntity>> list = this.views;
        synchronized (list) {
            this.views.add(entityView);
        }
    }

    EntityView<IEntity> getEntityViewAt(double d, double d2, int n, int n2) {
        EntityView<IEntity> entityView = this.getOccupyingEntityViewAt(d, d2, false);
        if (entityView != null) {
            return entityView;
        }
        return this.getVisibleEntityViewAt(n, n2, false);
    }

    EntityView<IEntity> getMovableEntityViewAt(double d, double d2, int n, int n2) {
        EntityView<IEntity> entityView = this.getOccupyingEntityViewAt(d, d2, true);
        if (entityView != null) {
            return entityView;
        }
        return this.getVisibleEntityViewAt(n, n2, true);
    }

    private EntityView<IEntity> getOccupyingEntityViewAt(double d, double d2, boolean bl) {
        EntityView<IEntity> entityView = null;
        ListIterator<EntityView<IEntity>> listIterator = this.visibleViews.listIterator(this.visibleViews.size());
        boolean bl2 = false;
        while (listIterator.hasPrevious()) {
            EntityView<IEntity> entityView2 = listIterator.previous();
            IEntity iEntity = entityView2.getEntity();
            if (bl && iEntity instanceof Player && !((Player)iEntity).isUser() && iEntity.getArea().contains(d, d2)) {
                bl2 = true;
            }
            if (bl && !entityView2.isMovable() || !iEntity.getArea().contains(d, d2)) continue;
            if (bl2) {
                if (entityView == null) {
                    entityView = entityView2;
                }
                if (!(iEntity instanceof Item) || !this.userName.equals(iEntity.getRPObject().get("bound"))) continue;
                return entityView2;
            }
            return entityView2;
        }
        return entityView;
    }

    private EntityView<IEntity> getVisibleEntityViewAt(int n, int n2, boolean bl) {
        ListIterator<EntityView<IEntity>> listIterator = this.visibleViews.listIterator(this.visibleViews.size());
        while (listIterator.hasPrevious()) {
            EntityView<IEntity> entityView = listIterator.previous();
            if (!entityView.getArea().contains(n, n2) || bl && !entityView.isMovable()) continue;
            return entityView;
        }
        return null;
    }

    void removeEntity(IEntity iEntity) {
        EntityView<IEntity> entityView = this.entities.remove(iEntity);
        if (entityView != null) {
            this.removeEntityView(entityView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntityView(EntityView<IEntity> entityView) {
        List<EntityView<IEntity>> list = this.views;
        synchronized (list) {
            this.views.remove(entityView);
            entityView.release();
        }
    }

    void resetViews() {
        for (Map.Entry<IEntity, EntityView<IEntity>> entry : this.entities.entrySet()) {
            entry.getValue().initialize(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareViews(Rectangle rectangle) {
        this.visibleViews.clear();
        List<EntityView<IEntity>> list = this.views;
        synchronized (list) {
            for (EntityView<IEntity> entityView : this.views) {
                entityView.applyChanges();
                if (!rectangle.intersects(entityView.getArea())) continue;
                this.visibleViews.add(entityView);
            }
        }
        Collections.sort(this.visibleViews, entityViewComparator);
    }

    void draw(Graphics2D graphics2D) {
        for (EntityView<IEntity> entityView : this.visibleViews) {
            try {
                entityView.draw(graphics2D);
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
    }

    void drawTop(Graphics2D graphics2D) {
        for (EntityView<IEntity> entityView : this.visibleViews) {
            try {
                entityView.drawTop(graphics2D);
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
    }

    private static class EntityViewComparator
    implements Comparator<EntityView<IEntity>> {
        private EntityViewComparator() {
        }

        @Override
        public int compare(EntityView<IEntity> entityView, EntityView<IEntity> entityView2) {
            int n = entityView.getZIndex() - entityView2.getZIndex();
            if (n == 0) {
                Rectangle rectangle = entityView.getArea();
                Rectangle rectangle2 = entityView2.getArea();
                n = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
                if (n == 0) {
                    n = entityView.getEntity().getID().getObjectID() - entityView2.getEntity().getID().getObjectID();
                }
            }
            return n;
        }
    }
}

