/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.listener.RPObjectChangeListener;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

class RPObjectChangeDispatcher {
    private static final Logger logger = Logger.getLogger(RPObjectChangeDispatcher.class);
    private RPObjectChangeListener listener;
    private RPObjectChangeListener userListener;

    RPObjectChangeDispatcher(RPObjectChangeListener rPObjectChangeListener, RPObjectChangeListener rPObjectChangeListener2) {
        this.listener = rPObjectChangeListener;
        this.userListener = rPObjectChangeListener2;
    }

    void dispatchAdded(RPObject rPObject) {
        try {
            logger.debug((Object)("Object(" + rPObject.getID() + ") added to client"));
            this.fireAdded(rPObject);
        }
        catch (Exception exception) {
            logger.error((Object)("dispatchAdded failed, object is " + rPObject), (Throwable)exception);
        }
    }

    void dispatchRemoved(RPObject rPObject) {
        try {
            logger.debug((Object)("Object(" + rPObject.getID() + ") removed from client"));
            this.fireRemoved(rPObject);
        }
        catch (Exception exception) {
            logger.error((Object)("dispatchRemovedonDeleted failed, object is " + rPObject), (Throwable)exception);
        }
    }

    void dispatchModifyAdded(RPObject rPObject, RPObject rPObject2) {
        try {
            logger.debug((Object)("Object(" + rPObject.getID() + ") modified in client"));
            this.fireChangedAdded(rPObject, rPObject2);
            rPObject.applyDifferences(rPObject2, null);
        }
        catch (Exception exception) {
            logger.error((Object)("dispatchModifyAdded failed, object is " + rPObject + ", changes is " + rPObject2), (Throwable)exception);
        }
    }

    void dispatchModifyRemoved(RPObject rPObject, RPObject rPObject2) {
        if (rPObject != null) {
            try {
                logger.debug((Object)("Object(" + rPObject.getID() + ") modified in client"));
                logger.debug((Object)("Original(" + rPObject + ") modified in client"));
                this.fireChangedRemoved(rPObject, rPObject2);
                rPObject.applyDifferences(null, rPObject2);
                logger.debug((Object)("Modified(" + rPObject + ") modified in client"));
                logger.debug((Object)("Changes(" + rPObject2 + ") modified in client"));
            }
            catch (Exception exception) {
                logger.error((Object)("dispatchModifyRemoved failed, object is " + rPObject + ", changes is " + rPObject2), (Throwable)exception);
            }
        } else {
            logger.error((Object)("dispatchModifyRemoved failed, object is null, changes is " + rPObject2));
        }
    }

    private void fireAdded(RPObject rPObject) {
        this.listener.onAdded(rPObject);
        this.userListener.onAdded(rPObject);
        for (RPSlot rPSlot : rPObject.slots()) {
            String string = rPSlot.getName();
            for (RPObject rPObject2 : rPSlot) {
                this.fireAdded(rPObject, string, rPObject2);
            }
        }
    }

    private void fireAdded(RPObject rPObject, String string, RPObject rPObject2) {
        this.fireAdded(rPObject2);
        this.listener.onSlotAdded(rPObject, string, rPObject2);
        this.userListener.onSlotAdded(rPObject, string, rPObject2);
    }

    private void fireChangedAdded(RPObject rPObject, RPObject rPObject2) {
        for (RPSlot rPSlot : rPObject2.slots()) {
            if (rPSlot.size() == 0) continue;
            this.fireChangedAdded(rPObject, rPSlot);
        }
        this.listener.onChangedAdded(rPObject, rPObject2);
        this.userListener.onChangedAdded(rPObject, rPObject2);
    }

    private void fireChangedAdded(RPObject rPObject, RPSlot rPSlot) {
        String string = rPSlot.getName();
        RPSlot rPSlot2 = rPObject.hasSlot(string) ? rPObject.getSlot(string) : null;
        for (RPObject rPObject2 : rPSlot) {
            RPObject.ID iD = rPObject2.getID();
            if (rPSlot2 != null && rPSlot2.has(iD)) {
                RPObject rPObject3 = rPSlot2.get(iD);
                this.listener.onSlotChangedAdded(rPObject, string, rPObject3, rPObject2);
                this.userListener.onSlotChangedAdded(rPObject, string, rPObject3, rPObject2);
                this.fireChangedAdded(rPObject3, rPObject2);
                continue;
            }
            if (!rPObject2.isContained()) {
                logger.warn((Object)("!!! Not contained! - " + rPObject2));
            }
            this.fireAdded(rPObject, string, rPObject2);
        }
    }

    private void fireChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        this.listener.onChangedRemoved(rPObject, rPObject2);
        this.userListener.onChangedRemoved(rPObject, rPObject2);
        for (RPSlot rPSlot : rPObject2.slots()) {
            if (rPSlot.size() == 0) continue;
            this.fireChangedRemoved(rPObject, rPSlot);
        }
    }

    private void fireChangedRemoved(RPObject rPObject, RPSlot rPSlot) {
        String string = rPSlot.getName();
        RPSlot rPSlot2 = rPObject.getSlot(string);
        for (RPObject rPObject2 : rPSlot) {
            RPObject rPObject3 = rPSlot2.get(rPObject2.getID());
            if (rPObject3 == null) {
                logger.debug((Object)("Unable to find existing: " + rPObject2));
                continue;
            }
            if (rPObject2.size() > 1) {
                this.listener.onSlotChangedRemoved(rPObject, string, rPObject3, rPObject2);
                this.userListener.onSlotChangedRemoved(rPObject, string, rPObject3, rPObject2);
                this.fireChangedRemoved(rPObject3, rPObject2);
                continue;
            }
            this.fireRemoved(rPObject, string, rPObject3);
        }
    }

    private void fireRemoved(RPObject rPObject) {
        for (RPSlot rPSlot : rPObject.slots()) {
            String string = rPSlot.getName();
            for (RPObject rPObject2 : rPSlot) {
                this.fireRemoved(rPObject, string, rPObject2);
            }
        }
        this.listener.onRemoved(rPObject);
        this.userListener.onRemoved(rPObject);
    }

    private void fireRemoved(RPObject rPObject, String string, RPObject rPObject2) {
        this.listener.onSlotRemoved(rPObject, string, rPObject2);
        this.userListener.onSlotRemoved(rPObject, string, rPObject2);
        this.fireRemoved(rPObject2);
    }
}

