/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.PerceptionDispatcher;
import games.stendhal.client.RPObjectChangeDispatcher;
import games.stendhal.client.UserContext;
import java.util.Map;
import marauroa.client.net.IPerceptionListener;
import marauroa.common.game.RPObject;
import marauroa.common.net.message.MessageS2CPerception;
import org.apache.log4j.Logger;

class StendhalPerceptionListener
implements IPerceptionListener {
    private static final Logger logger = Logger.getLogger(StendhalPerceptionListener.class);
    private PerceptionDispatcher dispatch = new PerceptionDispatcher();
    private final RPObjectChangeDispatcher rpobjDispatcher;
    private final UserContext userContext;
    private final Map<RPObject.ID, RPObject> world_objects;

    public StendhalPerceptionListener(PerceptionDispatcher perceptionDispatcher, RPObjectChangeDispatcher rPObjectChangeDispatcher, UserContext userContext, Map<RPObject.ID, RPObject> map) {
        this.userContext = userContext;
        this.dispatch = perceptionDispatcher;
        this.rpobjDispatcher = rPObjectChangeDispatcher;
        this.world_objects = map;
    }

    public boolean onAdded(RPObject rPObject) {
        if (this.userContext.isUser(rPObject)) {
            this.userContext.setPlayer(rPObject);
        }
        this.dispatch.onAdded(rPObject);
        this.rpobjDispatcher.dispatchAdded(rPObject);
        return false;
    }

    public boolean onModifiedAdded(RPObject rPObject, RPObject rPObject2) {
        this.dispatch.onModifiedAdded(rPObject, rPObject2);
        this.rpobjDispatcher.dispatchModifyAdded(rPObject, rPObject2);
        return true;
    }

    public boolean onModifiedDeleted(RPObject rPObject, RPObject rPObject2) {
        this.dispatch.onModifiedDeleted(rPObject, rPObject2);
        this.rpobjDispatcher.dispatchModifyRemoved(rPObject, rPObject2);
        return true;
    }

    public boolean onDeleted(RPObject rPObject) {
        this.dispatch.onDeleted(rPObject);
        this.rpobjDispatcher.dispatchRemoved(rPObject);
        return false;
    }

    public boolean onMyRPObject(RPObject rPObject, RPObject rPObject2) {
        this.dispatch.onMyRPObject(rPObject, rPObject2);
        try {
            RPObject.ID iD = null;
            if (rPObject != null) {
                iD = rPObject.getID();
            }
            if (rPObject2 != null) {
                iD = rPObject2.getID();
            }
            if (iD == null) {
                return true;
            }
            RPObject rPObject3 = this.world_objects.get(iD);
            this.userContext.setPlayer(rPObject3);
            if (rPObject2 != null) {
                this.rpobjDispatcher.dispatchModifyRemoved(rPObject3, rPObject2);
            }
            if (rPObject != null) {
                this.rpobjDispatcher.dispatchModifyAdded(rPObject3, rPObject);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("onMyRPObject failed, added=" + rPObject + " deleted=" + rPObject2), (Throwable)exception);
        }
        return true;
    }

    public void onSynced() {
        this.dispatch.onSynced();
    }

    public void onUnsynced() {
        this.dispatch.onUnsynced();
    }

    public void onException(Exception exception, MessageS2CPerception messageS2CPerception) {
        this.dispatch.onException(exception, messageS2CPerception);
        logger.error((Object)("perception caused an error: " + messageS2CPerception), (Throwable)exception);
        System.exit(-1);
    }

    public boolean onClear() {
        this.dispatch.onClear();
        return false;
    }

    public void onPerceptionBegin(byte by, int n) {
        this.dispatch.onPerceptionBegin(by, n);
    }

    public void onPerceptionEnd(byte by, int n) {
        this.dispatch.onPerceptionEnd(by, n);
    }
}

