/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.LayerRenderer;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.Tileset;
import games.stendhal.common.tiled.LayerDefinition;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

class TileRenderer
extends LayerRenderer {
    private static final Logger logger = Logger.getLogger(TileRenderer.class);
    protected Tileset tileset;
    protected int[] map = null;
    protected Sprite[] spriteMap = null;

    public void setMapData(InputStream inputStream) throws IOException, ClassNotFoundException {
        LayerDefinition layerDefinition = LayerDefinition.decode(inputStream);
        this.width = layerDefinition.getWidth();
        this.height = layerDefinition.getHeight();
        logger.debug((Object)("Layer(" + layerDefinition.getName() + "): " + this.width + "x" + this.height));
        this.map = layerDefinition.expose();
    }

    @Override
    public void setTileset(Tileset tileset) {
        this.tileset = tileset;
    }

    private boolean initSpriteMap() {
        if (this.spriteMap == null) {
            if (this.tileset != null) {
                this.spriteMap = new Sprite[this.map.length];
                int n = this.spriteMap.length;
                while (n-- != 0) {
                    this.spriteMap[n] = this.tileset.getSprite(this.map[n]);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.initSpriteMap()) {
            return;
        }
        int n5 = Math.min(n + n3, this.getWidth());
        int n6 = Math.min(n2 + n4, this.getHeight());
        int n7 = n2 * 32;
        for (int i = n2; i < n6; ++i) {
            int n8 = i * this.width + n;
            int n9 = n * 32;
            for (int j = n; j < n5; ++j) {
                this.spriteMap[n8].draw(graphics, n9, n7);
                ++n8;
                n9 += 32;
            }
            n7 += 32;
        }
    }
}

