/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.actions;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameScreen;
import games.stendhal.client.actions.SlashAction;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.stendhal;
import games.stendhal.common.NotificationType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

class ScreenshotAction
implements SlashAction {
    ScreenshotAction() {
    }

    @Override
    public boolean execute(String[] stringArray, String string) {
        ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "Taking a screenshot...", NotificationType.CLIENT));
        GameScreen gameScreen = GameScreen.get();
        int n = gameScreen.getWidth();
        int n2 = gameScreen.getHeight();
        final BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        gameScreen.paintComponent(graphics);
        graphics.dispose();
        final String string2 = this.getFileName();
        new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                File file = new File(string2);
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return "Screenshot was saved to " + string2;
            }

            @Override
            public void done() {
                String string = "";
                try {
                    string = (String)this.get();
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(ScreenshotAction.class).error((Object)interruptedException);
                }
                catch (ExecutionException executionException) {
                    string = "Failed to save screenshot to " + string2 + " : ";
                    Throwable throwable = executionException.getCause();
                    Logger.getLogger(ScreenshotAction.class).error((Object)executionException);
                    string = throwable != null ? throwable.getMessage() : executionException.getMessage();
                }
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string, NotificationType.CLIENT));
            }
        }.execute();
        return true;
    }

    private String getFileName() {
        String string = new SimpleDateFormat("-yyyy.MM.dd-HH.mm.ss").format(new Date());
        return stendhal.getGameFolder() + stendhal.GAME_NAME.toLowerCase() + string + ".png";
    }

    @Override
    public int getMaximumParameters() {
        return 0;
    }

    @Override
    public int getMinimumParameters() {
        return 0;
    }
}

