/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.Property;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.User;
import games.stendhal.common.NotificationType;
import games.stendhal.common.constants.SoundLayer;
import marauroa.common.game.RPObject;

public class Player
extends RPEntity {
    public static final Property PROP_AWAY = new Property();
    public static final Property PROP_GRUMPY = new Property();
    public static final Property PROP_PLAYER_KILLER = new Property();
    private static final String LAST_PLAYER_KILL_TIME = "last_player_kill_time";
    private String away = null;
    private String grumpy = null;
    private boolean badboy;

    public boolean isAway() {
        return this.getAway() != null;
    }

    public boolean isBadBoy() {
        return this.badboy;
    }

    public String getAway() {
        return this.away;
    }

    protected void onAway(String string) {
        if (this.messageChanged(this.away, string)) {
            this.away = string;
            this.fireChange(PROP_AWAY);
            if (string != null) {
                this.addTextIndicator("Away", NotificationType.INFORMATION);
            } else {
                this.addTextIndicator("Back", NotificationType.INFORMATION);
            }
        }
    }

    public boolean isGrumpy() {
        return this.grumpy != null;
    }

    private void onGrumpy(String string) {
        if (this.messageChanged(this.grumpy, string)) {
            this.grumpy = string;
            this.fireChange(PROP_GRUMPY);
            if (string != null) {
                this.addTextIndicator("Grumpy", NotificationType.INFORMATION);
            } else {
                this.addTextIndicator("Receptive", NotificationType.INFORMATION);
            }
        }
    }

    private boolean messageChanged(String string, String string2) {
        return string2 == null && string != null || string2 != null && !string2.equals(string);
    }

    @Override
    public void onTalk(String string) {
        if (!User.isIgnoring(this.getName())) {
            super.onTalk(string);
        }
    }

    @Override
    public void onDamaged(Entity entity, int n) {
        super.onDamaged(entity, n);
        this.playRandomSoundFromCategory(SoundLayer.FIGHTING_NOISE.groupName, "attack");
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject2.has("away")) {
            this.onAway(rPObject2.get("away"));
        }
        if (rPObject2.has("grumpy")) {
            this.onGrumpy(rPObject2.get("grumpy"));
        }
        if (rPObject2.has(LAST_PLAYER_KILL_TIME)) {
            this.badboy = true;
            this.fireChange(PROP_PLAYER_KILLER);
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        super.onChangedRemoved(rPObject, rPObject2);
        if (rPObject2.has("away")) {
            this.onAway(null);
        }
        if (rPObject2.has("grumpy")) {
            this.onGrumpy(null);
        }
        if (rPObject2.has(LAST_PLAYER_KILL_TIME)) {
            this.badboy = false;
            this.fireChange(PROP_PLAYER_KILLER);
        }
    }
}

