/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.events.Event;
import games.stendhal.common.constants.Nature;
import org.apache.log4j.Logger;

public class AttackEvent
extends Event<RPEntity> {
    private static final Logger logger = Logger.getLogger(AttackEvent.class);

    @Override
    public void execute() {
        Nature nature;
        int n = this.event.getInt("type");
        try {
            nature = Nature.values()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.warn((Object)("Unknown damage type: " + n));
            nature = Nature.CUT;
        }
        RPEntity rPEntity = ((RPEntity)this.entity).getAttackTarget();
        if (rPEntity != null) {
            boolean bl = this.event.has("ranged");
            if (this.event.has("hit")) {
                int n2 = this.event.getInt("damage");
                if (n2 != 0) {
                    rPEntity.onDamaged(this.entity, n2);
                } else {
                    rPEntity.onBlocked();
                }
            } else {
                rPEntity.onMissed();
            }
            ((RPEntity)this.entity).onAttackPerformed(nature, bl, this.event.get("weapon"));
        }
    }
}

