/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.j2d.Blend;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorSelector<T extends ColorSelectionModel>
extends JPanel {
    private final T model;

    AbstractColorSelector(T t) {
        this.model = t;
        this.setBorder(null);
        this.setLayout(new SBoxLayout(false, 5));
    }

    T getSelectionModel() {
        return this.model;
    }

    static abstract class AbstractSpriteColorSelector<T extends ColorSelectionModel>
    extends AbstractSelector<T> {
        static final int SPRITE_WIDTH = 80;
        static final int SPRITE_HEIGHT = 52;
        private Sprite normalSprite;
        private Sprite disabledSprite;

        AbstractSpriteColorSelector(T t) {
            super(t);
        }

        abstract Sprite createNormalSprite();

        private Sprite getNormalSprite() {
            if (this.normalSprite == null) {
                this.normalSprite = this.createNormalSprite();
            }
            return this.normalSprite;
        }

        Sprite getBackgroundSprite() {
            if (this.isEnabled()) {
                return this.getNormalSprite();
            }
            if (this.disabledSprite == null) {
                Sprite sprite = this.getNormalSprite();
                if (sprite.getReference() != null) {
                    SpriteCache.get().add(sprite.getReference(), sprite);
                    this.disabledSprite = SpriteStore.get().getColoredSprite(sprite.getReference().toString(), Color.GRAY);
                } else {
                    this.disabledSprite = SpriteStore.get().modifySprite(sprite, Color.GRAY, Blend.TrueColor, null);
                }
            }
            return this.disabledSprite;
        }

        @Override
        public Dimension getPreferredSize() {
            Sprite sprite = this.getBackgroundSprite();
            int n = sprite.getWidth();
            int n2 = sprite.getHeight();
            Insets insets = this.getInsets();
            return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            Sprite sprite = this.getBackgroundSprite();
            sprite.draw(graphics, insets.left, insets.right);
        }

        @Override
        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            super.setEnabled(bl);
            if (bl2 != bl) {
                this.repaint();
            }
        }
    }

    static abstract class AbstractSelector<T extends ColorSelectionModel>
    extends JComponent
    implements ChangeListener {
        final T model;

        AbstractSelector(T t) {
            this.model = t;
            t.addChangeListener(this);
            this.setOpaque(true);
            this.applyStyle();
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (AbstractSelector.this.isEnabled()) {
                        AbstractSelector.this.select(mouseEvent.getPoint());
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (AbstractSelector.this.isEnabled()) {
                        AbstractSelector.this.select(mouseEvent.getPoint());
                    }
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.repaint();
        }

        private void applyStyle() {
            Style style = StyleUtil.getStyle();
            if (style != null) {
                this.setBorder(style.getBorderDown());
            }
        }

        abstract void select(Point var1);
    }
}

