/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.ComponentPaintCache;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.common.constants.SoundLayer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class InternalWindow
extends JPanel
implements ComponentPaintCache.Cacheable {
    private static final long serialVersionUID = 7086677981083580331L;
    private static final int TITLEBAR_HEIGHT = 13;
    private static final int TITLEBAR_PADDING = 2;
    private static Icon closeIcon;
    private static Icon minimizeIcon;
    private final TitleBar titleBar;
    final JButton minimizeButton;
    final JButton closeButton;
    final JLabel titleLabel;
    private JComponent content;
    private boolean hideOnClose = false;
    private String openSound = "click-10";
    private String minimizeSound = "click-8";
    private String closeSound = "click-6";
    private final List<CloseListener> closeListeners = new LinkedList<CloseListener>();
    private final ComponentPaintCache cache;

    InternalWindow(String string) {
        this.setLayout(new BorderLayout());
        this.titleBar = new TitleBar();
        this.add((Component)this.titleBar, "North");
        this.titleBar.setLayout(new SBoxLayout(true, 2));
        this.titleLabel = new JLabel();
        this.setTitle(string);
        this.titleLabel.setMinimumSize(new Dimension(0, 0));
        this.titleBar.add(this.titleLabel);
        SBoxLayout.addSpring(this.titleBar);
        this.minimizeButton = new JButton(minimizeIcon);
        this.minimizeButton.setMargin(new Insets(0, 0, 0, 0));
        this.minimizeButton.setBorder(BorderFactory.createEmptyBorder());
        this.minimizeButton.setFocusable(false);
        this.minimizeButton.addActionListener(new MinimizeListener());
        this.titleBar.add(this.minimizeButton);
        this.closeButton = new JButton(closeIcon);
        this.closeButton.setMargin(new Insets(0, 0, 0, 0));
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(new CloseActionListener());
        this.titleBar.add(this.closeButton);
        this.cache = new ComponentPaintCache(this);
    }

    public void addCloseListener(CloseListener closeListener) {
        this.closeListeners.add(closeListener);
    }

    public void setContent(JComponent jComponent) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.add((Component)jComponent, "Center");
        this.content = jComponent;
        this.titleBar.setPreferredWidth(jComponent.getPreferredSize().width);
    }

    public void setCloseable(boolean bl) {
        this.closeButton.setVisible(bl);
    }

    public void setHideOnClose(boolean bl) {
        this.hideOnClose = bl;
    }

    public void setMinimizable(boolean bl) {
        this.minimizeButton.setVisible(bl);
    }

    public boolean isMinimized() {
        return !this.content.isVisible();
    }

    public void setMinimized(boolean bl) {
        if (bl) {
            this.titleBar.hideBorder();
        } else {
            this.titleBar.restoreBorder();
        }
        this.content.setVisible(!bl);
    }

    protected JComponent getTitlebar() {
        return this.titleBar;
    }

    public final void setTitle(String string) {
        string = string.replaceAll(" +", "&nbsp;");
        string = "<html>" + string + "</html>";
        this.titleLabel.setText(string);
    }

    public void close() {
        if (this.hideOnClose) {
            this.setVisible(false);
        } else {
            Container container = this.getParent();
            if (container != null) {
                container.remove(this);
                container.validate();
                container.repaint();
            }
        }
        for (CloseListener closeListener : this.closeListeners) {
            closeListener.windowClosed(this);
        }
    }

    private void playSound(String string) {
        ClientSingletonRepository.getSound().getGroup(SoundLayer.USER_INTERFACE.groupName).play(string, 0, null, null, false, true);
    }

    private static void createIcons() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Image image = InternalWindow.createIconBackground(graphicsConfiguration);
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(13, 13, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.drawImage(image, 0, 0, null);
        closeIcon = InternalWindow.createCloseIcon(bufferedImage);
        minimizeIcon = InternalWindow.createMinimizeIcon(image);
    }

    private static Image createIconBackground(GraphicsConfiguration graphicsConfiguration) {
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(13, 13, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Style style = StyleUtil.getStyle();
        if (style != null) {
            style.getBackground().draw(graphics2D, 0, 0);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, 13, 13);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static Icon createCloseIcon(Image image) {
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(1, 2, 10, 11);
        graphics.drawLine(1, 1, 11, 11);
        graphics.drawLine(2, 1, 11, 10);
        graphics.drawLine(10, 1, 1, 10);
        graphics.drawLine(11, 1, 1, 11);
        graphics.drawLine(11, 2, 2, 11);
        graphics.dispose();
        return new ImageIcon(image);
    }

    private static Icon createMinimizeIcon(Image image) {
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(1, 10, 11, 2);
        return new ImageIcon(image);
    }

    @Override
    public void paint(Graphics graphics) {
        this.cache.paintComponent(graphics);
        this.paintChildren(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    public void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    static {
        InternalWindow.createIcons();
    }

    private static class TitleBar
    extends JPanel
    implements ComponentPaintCache.Cacheable {
        private static final long serialVersionUID = -6859560118307192124L;
        private Insets insets = this.getInsets();
        private final Border border;
        private final ComponentPaintCache cache;
        private int preferredWidth = -1;

        TitleBar() {
            this.border = BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(-this.insets.top, 0, 0, 0));
            this.setBorder(this.border);
            this.cache = new ComponentPaintCache(this);
        }

        void hideBorder() {
            Insets insets = this.getInsets();
            this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }

        void restoreBorder() {
            this.setBorder(this.border);
        }

        void setPreferredWidth(int n) {
            this.preferredWidth = n;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.preferredWidth != -1) {
                dimension.width = this.preferredWidth;
            }
            return dimension;
        }

        @Override
        public void paintBorder(Graphics graphics) {
            Graphics graphics2 = graphics.create();
            graphics2.clipRect(0, this.getHeight() - this.insets.bottom, this.getWidth(), this.getHeight());
            this.getBorder().paintBorder(this, graphics2, -this.insets.left, 0, this.getWidth() + this.insets.left + this.insets.right, this.getHeight());
            graphics2.dispose();
        }

        @Override
        public void paint(Graphics graphics) {
            this.cache.paintComponent(graphics);
            this.paintChildren(graphics);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }

        @Override
        public void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
        }
    }

    private class MinimizeListener
    implements ActionListener {
        private MinimizeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InternalWindow.this.setMinimized(!InternalWindow.this.isMinimized());
            if (InternalWindow.this.isMinimized()) {
                InternalWindow.this.playSound(InternalWindow.this.openSound);
            } else {
                InternalWindow.this.playSound(InternalWindow.this.minimizeSound);
            }
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InternalWindow.this.close();
            InternalWindow.this.playSound(InternalWindow.this.closeSound);
        }
    }

    public static interface CloseListener {
        public void windowClosed(InternalWindow var1);
    }
}

