/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.AbstractColorSelector;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.common.MathHelper;
import games.stendhal.common.constants.SkinColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.colorchooser.DefaultColorSelectionModel;

class SkinColorSelector
extends AbstractColorSelector<SkinColorSelectionModel> {
    private final JComponent paletteSelector = new SkinPaletteSelector((SkinColorSelectionModel)this.getSelectionModel());

    SkinColorSelector() {
        super(new SkinColorSelectionModel());
        this.add(this.paletteSelector);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.paletteSelector.setEnabled(bl);
    }

    static class SkinColorSelectionModel
    extends DefaultColorSelectionModel {
        private SkinColor enumColor;

        SkinColorSelectionModel() {
        }

        void setSelectedColor(SkinColor skinColor) {
            if (skinColor == this.enumColor) {
                return;
            }
            this.enumColor = skinColor;
            super.setSelectedColor(new Color(this.enumColor.getColor()));
        }

        @Override
        public void setSelectedColor(Color color) {
            this.enumColor = color != null ? SkinColor.fromInteger(color.getRGB()) : SkinColor.COLOR1;
            super.setSelectedColor(new Color(this.enumColor.getColor()));
        }
    }

    private static class SkinPaletteSelector
    extends AbstractColorSelector.AbstractSpriteColorSelector<SkinColorSelectionModel> {
        private static final int COLOR_ITEM_WIDTH;
        private static final int COLOR_ITEM_HEIGHT;
        private static final SkinColor[][] COLOR_MAP;
        private int row;
        private int column;

        SkinPaletteSelector(SkinColorSelectionModel skinColorSelectionModel) {
            super(skinColorSelectionModel);
        }

        @Override
        Sprite createNormalSprite() {
            BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(80, 52);
            Graphics graphics = bufferedImage.getGraphics();
            for (int i = 0; i < COLOR_MAP.length; ++i) {
                for (int j = 0; j < COLOR_MAP[0].length; ++j) {
                    graphics.setColor(new Color(COLOR_MAP[i][j].getColor()));
                    graphics.fillRect(j * COLOR_ITEM_WIDTH, i * COLOR_ITEM_HEIGHT, COLOR_ITEM_WIDTH, COLOR_ITEM_HEIGHT);
                }
            }
            graphics.dispose();
            return new ImageSprite(bufferedImage, (Object)"skin_color_selection_id");
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.WHITE);
            Insets insets = this.getInsets();
            int n = insets.left + this.column * COLOR_ITEM_WIDTH;
            int n2 = insets.top + this.row * COLOR_ITEM_HEIGHT;
            graphics.drawRect(n, n2, COLOR_ITEM_WIDTH - 1, COLOR_ITEM_HEIGHT - 1);
        }

        @Override
        void select(Point point) {
            Insets insets = this.getInsets();
            this.row = (point.y - insets.top) / COLOR_ITEM_HEIGHT;
            this.column = (point.x - insets.left) / COLOR_ITEM_WIDTH;
            this.column = MathHelper.clamp(this.column, 0, COLOR_MAP.length - 1);
            this.row = MathHelper.clamp(this.row, 0, COLOR_MAP[0].length - 1);
            SkinColor skinColor = COLOR_MAP[this.row][this.column];
            ((SkinColorSelectionModel)this.model).setSelectedColor(skinColor);
        }

        static {
            int n;
            int n2;
            SkinColor[] skinColorArray = SkinColor.values();
            int n3 = skinColorArray.length;
            int n4 = 1;
            int n5 = 1;
            for (n2 = n = (int)Math.ceil(Math.sqrt(n3)); n2 >= 1; --n2) {
                if (n3 % n2 != 0) continue;
                n4 = n2;
                n5 = n3 / n2;
                break;
            }
            COLOR_MAP = new SkinColor[n5][];
            n2 = 0;
            for (int i = 0; i < n5; ++i) {
                SkinColor[] skinColorArray2 = new SkinColor[n4];
                SkinPaletteSelector.COLOR_MAP[i] = skinColorArray2;
                for (int j = 0; j < n4; ++j) {
                    skinColorArray2[j] = skinColorArray[n2];
                    ++n2;
                }
            }
            COLOR_ITEM_WIDTH = 80 / n4;
            COLOR_ITEM_HEIGHT = 52 / n5;
        }
    }
}

