/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.ScalingModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatusDisplayBar
extends JComponent {
    private static final int PREFERRED_HEIGHT = 10;
    private final ScalingModel model;
    private Color color = Color.WHITE;
    private BarPainter painter;
    private BufferedImage barImage;

    public StatusDisplayBar(final ScalingModel scalingModel) {
        this.model = scalingModel;
        this.setForeground(Color.BLACK);
        this.setBackground(Color.BLACK);
        scalingModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                StatusDisplayBar.this.valueChanged();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n;
                Insets insets = StatusDisplayBar.this.getInsets();
                int n2 = StatusDisplayBar.this.getWidth() - insets.left - insets.right - 2;
                if (StatusDisplayBar.this.painter != null && n2 > 0 && (n = StatusDisplayBar.this.getHeight() - insets.top - insets.bottom) > 0) {
                    StatusDisplayBar.this.barImage = StatusDisplayBar.this.getGraphicsConfiguration().createCompatibleImage(n2, n);
                    Graphics2D graphics2D = StatusDisplayBar.this.barImage.createGraphics();
                    StatusDisplayBar.this.painter.paint(graphics2D, n2, n);
                    graphics2D.dispose();
                }
                scalingModel.setMaxRepresentation(n2);
            }
        });
        this.setPreferredSize(new Dimension(2, 10));
        this.setMinimumSize(this.getPreferredSize());
    }

    public ScalingModel getModel() {
        return this.model;
    }

    public void setBarColor(Color color) {
        this.color = color;
    }

    protected void setPainter(BarPainter barPainter) {
        this.painter = barPainter;
    }

    protected void valueChanged() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getHeight() - insets.top - insets.bottom - 2;
        graphics.setColor(this.getForeground());
        graphics.drawRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right - 1, this.getHeight() - insets.top - insets.bottom - 1);
        graphics.setColor(this.getBackground());
        graphics.fillRect(insets.left + 1, insets.top + 1, this.getWidth() - insets.left - insets.right - 2, n);
        if (this.barImage != null) {
            Graphics graphics2 = graphics.create(insets.left + 1, insets.top + 1, this.model.getRepresentation(), n);
            graphics2.drawImage(this.barImage, 0, 0, null);
            graphics2.dispose();
        } else {
            graphics.setColor(this.color);
            graphics.fillRect(insets.left + 1, insets.top + 1, this.model.getRepresentation(), n);
        }
    }

    public static interface BarPainter {
        public void paint(Graphics2D var1, int var2, int var3);
    }
}

